/***************************************************************************************************
**  File name    : System.c
**  Function     : 
**  Author       : yangf
**  Date         : 2013/1/17
**  Version      : v1.0
**  Description  : 
**  ModifyRecord :
***************************************************************************************************/
/*

|___________________________________________________________________________________________________________________________
|                     ϵͳָƴ洢ӳϵ 
|__________________________________________________________________________________________________________________________
|ûID             |                  |                      |                      |                      |
|                   |       1          |          2           |           3          |         n...         |  
|1IDnģ |                  |                      |                      |                      |         
|___________________|__________________|______________________|______________________|______________________|_______________
|                   |     |     |      |      |      |        |      |      |        |      |      |        | 
|ָ           |  0  |  1  |  m.. |2*m+1 | 2*m+2| 2*m+.. |3*m+1 | 3*m+2| 3*m+.. |n*m+1 | n*m+2| n*m+.. |... 
|gcpMBIndex         |     |     |      |      |      |        |      |      |        |      |      |        | 
|___________________|_____|_____|______|______|______|________|______|______|________|______|______|________|_______________
|                   |     |     |      |      |      |        |      |      |        |      |      |        | 
|ָģ           | 256 |256  |256   | 256  |256   |256 ..  | 256  |256   |256  .. | 256  | 256  |256  .. | ..ֽ 
|㷨         |     |     |      |      |      |        |      |      |        |      |      |        | 
|___________________|_____|_____|______|______|______|________|______|______|________|______|______|________|_______________
*/
/***************************************************************************************************
** Include Header Files
***************************************************************************************************/
#include "SYglobal.h"

/***************************************************************************************************
** Local Macro Definition
***************************************************************************************************/

/***************************************************************************************************
** Local Type Definition
***************************************************************************************************/

/***************************************************************************************************
** Local static Variable Declaration
***************************************************************************************************/

/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/
extern UINT8 gcpMBIndex[]; 
UINT8 gcpUserIndex[USER_NUM];               //gcpUserIndex[1]==1ʾ ID=1û,IDſԴλ  
StruMBFile gsCharBuffer1,gsCharBuffer2; 
//StruMBFile gsCharBuffer[FP_PER_USER];
SYNOC_SPARATAB gParaTab;
UINT16 giMBCounter;             //MB number accessed in flash
UINT16 gwPktSize;
UINT32 glPassWord;
UINT16 gwMatchScore;

extern void reset(void);

UINT8 ReadFlash(UINT8* pDataBuf,UINT32 nOffset,UINT16 nDataNum)
{
    return	SF_ReadData((UINT8*)pDataBuf,nOffset,nDataNum);      //expose parameter table
}
UINT8 WriteFlash(UINT8* pDataBuf,UINT32 nOffset,UINT16 nDataNum)
{
    return	SF_WriteData((UINT8*)pDataBuf,nOffset,nDataNum);      //expose parameter table
} 

/***************************************************************************************************
** Local Functon Declaration
***************************************************************************************************/

/***************************************************************************************************
* Functon
***************************************************************************************************/

/***************************************************************************************************
** Subroutine  : ParaGenBCC
** Function    : У 
** Input       : wpParaBuf-ָ
**               wParaBcc-У
** Output      : زУ 
** Description :   			 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT16 ParaGenBCC(UINT16 *wpParaBuf)
{
	UINT16 i;
	UINT16  wParaBcc;
	UINT16 *wpPara;
	
	wpPara = wpParaBuf;
	wParaBcc = 0;
	for(i = 0; i < WLENOFPARATAB-2; i++)
		wParaBcc ^= wpPara[i];
	
	return wParaBcc;
}
	
/***************************************************************************************************
** Subroutine  : ReadParaTab
** Function    :  
** Input       : 
** Output      : Ľ, RT_OK:ȡɹ;RT_FAIL:ȡʧ 
** Description :   			 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 ReadParaTab()
{
	return ReadFlash((UINT8*)&gParaTab,PARA_TAB_PAGE*SFLASH_PAGE_SIZE,sizeof(SYNOC_SPARATAB));//cpBuf	
}

/***************************************************************************************************
** Subroutine  : ReadParaTab
** Function    : д 
** Input       : 
** Output      : дĽ, RT_OK:ɹ;RT_FAIL:ʧ 
** Description :   			 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 WriteParaTab()
{
	gParaTab.ParaBcc =ParaGenBCC((void*)&gParaTab);
	return WriteFlash((UINT8*)&gParaTab,PARA_TAB_PAGE*SFLASH_PAGE_SIZE,sizeof(SYNOC_SPARATAB));//access parameter table
}
	
/***************************************************************************************************
** Subroutine  : InitParaTable
** Function    : ʼ 
** Input       : 
** Output      : 
** Description :   			 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void InitParaTable()
{
	
	memset(&gParaTab,0,sizeof(gParaTab));
	
	gParaTab.SSR = 0;
	gParaTab.SenType = 0;
	gParaTab.DataSize = USER_NUM;
	
	gParaTab.SecurLevel = SECURE_LEVEL;
	
	gParaTab.DeviceAddr[1] = 0xffff;
	gParaTab.DeviceAddr[0] = 0xffff;
	gParaTab.CFG_PktSize = 2;
	gParaTab.CFG_BaudRate = BAUDRATE;   //9600*6=57600
	
	gParaTab.ProductSN[0] = (PRUDUCT_SN[0]<<8) + PRUDUCT_SN[1];
	gParaTab.ProductSN[1] = (PRUDUCT_SN[2]<<8) + PRUDUCT_SN[3];
	gParaTab.ProductSN[2] = (PRUDUCT_SN[4]<<8) + PRUDUCT_SN[5];
	gParaTab.ProductSN[3] = (PRUDUCT_SN[6]<<8) + PRUDUCT_SN[7];
	
	gParaTab.ManuFacture[0] = (MANU_FACTURE[0]<<8) + MANU_FACTURE[1];
	gParaTab.ManuFacture[1] = (MANU_FACTURE[2]<<8) + MANU_FACTURE[3];
	gParaTab.ManuFacture[2] = (MANU_FACTURE[4]<<8) + MANU_FACTURE[5];
	gParaTab.ManuFacture[3] = (MANU_FACTURE[6]<<8) + MANU_FACTURE[7];
    
	gParaTab.SensorName[0] = (SENSOR_NAME[0]<<8) + SENSOR_NAME[1];
	gParaTab.SensorName[1] = (SENSOR_NAME[2]<<8) + SENSOR_NAME[3];
	gParaTab.SensorName[2] = (SENSOR_NAME[4]<<8) + SENSOR_NAME[5];
	gParaTab.SensorName[3] = (SENSOR_NAME[6]<<8) + SENSOR_NAME[7];

	gParaTab.PassWord[1] = 0x0000;
	gParaTab.PassWord[0] = 0x0000;
	
	gParaTab.SWVersion[0] = (FW_VERSION[0]<<8)  + FW_VERSION[1];
	gParaTab.SWVersion[1] = (FW_VERSION[2]<<8)  + FW_VERSION[3];
	gParaTab.SWVersion[2] = (FW_VERSION[4]<<8)  + FW_VERSION[5];
	gParaTab.SWVersion[3] = (FW_VERSION[6]<<8)  + FW_VERSION[7];
    
	gParaTab.JTAGLockFlg[1] = 0x0000;
	gParaTab.JTAGLockFlg[0] = 0x0000;
	
	gParaTab.ParaBcc = ParaGenBCC((void*)&gParaTab);
	gParaTab.ParaTabFlg = PARA_CHANGE;
	
}
	
/***************************************************************************************************
** Subroutine  : InitDeviceInfo
** Function    : ʼ豸 
** Input       : 
** Output      : 
** Description :   			 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/ 	
void InitDeviceInfo(void)
{
	UINT8 *ncpAddr;	
	UINT16 nParaEcc;
	
	ncpAddr = (UINT8 *)TEMP_BUFC;
	
	//ͨ־λʼģͼ±
	if (CheckSysInitFlag()==RT_FAIL )
	{
		ClearFPMBIndexAll(); //
		memset(ncpAddr,0,NOTEPAD_PAGE_N*SFLASH_PAGE_SIZE);
		WriteNoteData(ncpAddr,NOTEPAD_PAGE_N*SFLASH_PAGE_SIZE);//±Ϣ           
	}
	
    giMBCounter=UserStatistics(); //ͳģ
    
	ReadParaTab();
	
	nParaEcc=ParaGenBCC((void*)&gParaTab);
#if	((SENSOR_CHOICE != FP100)&&(SENSOR_CHOICE != FP108))	
	if( gParaTab.DataSize != FP_MB_MAX )
	{
		goto LABEXIT;
	}
#endif	
	if(gParaTab.ParaBcc != nParaEcc)                                            //ԭʼ
	{
		goto LABEXIT;                                                           //ˣȱʡ
	}
	
#if TRUE
	if(gParaTab.ParaTabFlg == PARA_CHANGE)    //жϲ޳ʼ
	{
        gsCommHandle.dwCommPsd=gParaTab.PassWord[0];
        gsCommHandle.dwCommPsd=((gsCommHandle.dwCommPsd & 0xffff) << 16) | (gParaTab.PassWord[1] & 0xffff);
       	
		switch(gParaTab.SecurLevel)
		{
			case 1: gwMatchScore=22;break;
			case 2: gwMatchScore=36;break;
			case 3: gwMatchScore=50;break;
			case 4: gwMatchScore=60;break;
			case 5: gwMatchScore=70;break;
			default: gwMatchScore=50;break;
		}
		
		if(gParaTab.CFG_PktSize == 0)
			gsCommHandle.dwPktSize = 32;
		else if(gParaTab.CFG_PktSize == 1)
			gsCommHandle.dwPktSize = 64;
		else if(gParaTab.CFG_PktSize == 2)
			gsCommHandle.dwPktSize = 128;
		else if(gParaTab.CFG_PktSize == 3)
			gsCommHandle.dwPktSize = 256;
		else
			gsCommHandle.dwPktSize = 128;
		
		return;
		
	}
	else
#endif
		LABEXIT:
	{
		gsCommHandle.dwPktSize = 128;
		gsCommHandle.cPwdVfyFg=0;
		gsCommHandle.dwCommPsd=0;
		
		InitParaTable();
		switch(gParaTab.SecurLevel)
		{
			case 1:  gwMatchScore=22;break;
			case 2:  gwMatchScore=36;break;
			case 3:  gwMatchScore=50;break;
			case 4:  gwMatchScore=60;break;
			case 5:  gwMatchScore=70;break;
			default: gwMatchScore=50;break;
		}
		WriteParaTab();
	}
}

//ͳû ,Чû 
UINT16 UserStatistics(void)
{ 
	UINT16 i,j,nCnt;
	GetFPMBIndex();
	nCnt=0;
	memset(gcpUserIndex,0,sizeof(gcpUserIndex) );
	for (i=0;i<USER_NUM;i++)
	{
		for (j=0;j<PER_MB_USER;j++)
		{
		  if (CheckVaildFPMBIndex(i*PER_MB_USER+j)==RT_OK)	
		  {
#if (IMD_AS608_REV_A_DEV_BOARD==1)
		if(gcpUserIndex[i]!=1)
#endif
    		  	nCnt++;
    			gcpUserIndex[i]=1;
		  }		   
			
		}		
	}	
	return nCnt;
}
//ȡϢ
UINT8 ReadSysPapaImfo(UINT8 *pDat)
{
	ReadFlash(pDat,PARA_TAB_PAGE*SFLASH_PAGE_SIZE,PARA_TAB_PAGE_N*SFLASH_PAGE_SIZE);    
	return RT_OK;
}
UINT8 ReadNoteData(UINT8 *pDat,UINT16 nLen)	
{
	ReadFlash(pDat,NOTEPAD_PAGE*SFLASH_PAGE_SIZE,nLen);
	return RT_OK;
}
UINT8 WriteNoteData(UINT8 *pDat,UINT16 nLen)	
{
	WriteFlash(pDat,NOTEPAD_PAGE*SFLASH_PAGE_SIZE,nLen);
	return RT_OK;
}
UINT8 WriteNoteDataPage(UINT8 *pDat,UINT16 offSet,UINT16 nLen)	
{
	WriteFlash(pDat,NOTEPAD_PAGE*SFLASH_PAGE_SIZE+offSet,nLen);
	return RT_OK;
}
UINT8 ReadNoteDataPage(UINT8 *pDat,UINT16 offSet,UINT16 nLen)	
{
	ReadFlash(pDat,NOTEPAD_PAGE*SFLASH_PAGE_SIZE+offSet,nLen);
	return RT_OK;
}
UINT8 ClearSysInitFlag(void)
{
	UINT8 Buf[4];
	Buf[0]=0;
	Buf[1]=0;
	Buf[2]=0;
	Buf[3]=0;
	WriteFlash(Buf,PARA_TAB_RVS*SFLASH_PAGE_SIZE,4);
	return RT_OK;
}
UINT8 SetSysInitFlag(void)
{
	UINT8 Buf[4];
	Buf[0]=0x05;
	Buf[1]=0x06;
	Buf[2]=0x07;
	Buf[3]=0x08;
	WriteFlash(Buf,PARA_TAB_RVS*SFLASH_PAGE_SIZE,4);
	return RT_OK;
}
UINT8 CheckSysInitFlag(void)
{
	UINT8 Buf[4];
	ReadFlash(Buf,PARA_TAB_RVS*SFLASH_PAGE_SIZE,4);
	if(Buf[0]!=0x05 || Buf[1]!=0x06 || Buf[2]!=0x07 || Buf[3]!=0x08)
	{
		Buf[0]=0x05;
		Buf[1]=0x06;
		Buf[2]=0x07;
		Buf[3]=0x08;
		SetSysInitFlag();
		return RT_FAIL;
	}	
	return RT_OK;
}

UINT8 GetFreeUesrId(UINT16 *pUserId)
{
	UINT16 i;
	for (i=0;i<USER_NUM;i++)
	{
		if (gcpUserIndex[i]!=1)
		{
			*pUserId=i;
			return RT_OK;
		}	
	}
    return RT_FAIL;	
}
UINT8 checkVaildUserId(UINT16 wUserId)
{
    
    if (wUserId>=USER_NUM)
        return RT_FAIL;
    if (gcpUserIndex[wUserId]==1)
    	return RT_OK;
	return RT_FAIL;
}
UINT8 SaveUserFp(StruMBFile *p,UINT16 wUserId)
{
//	UINT8 m;
    if (wUserId>=USER_NUM)
        return PS_ADDRESS_OVER;
//    print("עID = %d MBIndex=%d",wUserId,wUserId*PER_MB_USER );
	WriteFpMB_N((UINT8*)p,wUserId*PER_MB_USER,PER_MB_USER);
//	for(m=0;m<PER_MB_USER;m++)
//		SetFPMBIndexOne(wUserId*PER_MB_USER+m);
//#if IMD_LOCK == 1
//	//Currently, IMD_LOCK does not support FP learning.
//	SetFPMBIndexN(wUserId*PER_MB_USER,PER_MB_USER);
//#else
	SetFPMBIndexN(wUserId*PER_MB_USER,Enroll_MB_USER/ALG_TZ_MB); 
//#endif
	giMBCounter=UserStatistics();
//	 print("\r\n");
	return RT_OK;
}
//ûMB 
UINT8 AddUserFpMb(UINT8 *pDat,UINT16 wUserId)
{
	UINT16 i,j;
	UINT8 cRet;
	UINT8 Tz[ALG_SIZE_TZ];
	memcpy(Tz,pDat,ALG_SIZE_TZ);
    cRet=GetUserFp(&gsCharBuffer2,wUserId);
    if (cRet==RT_OK)
    {
        for (i=0;i<PER_MB_USER;i++)//for (i=1;i<PER_MB_USER;i++)
    	{
            for (j=0;j<ALG_TZ_MB;j++)
            {
            	if (gsCharBuffer2.cCharFile[i*ALG_TZ_MB+j][0]!=(ALG_TZ_VailHead&0xff)||gsCharBuffer2.cCharFile[i*ALG_TZ_MB+j][1]!=((ALG_TZ_VailHead>>8)&0xff))
            	{
            		memcpy(&gsCharBuffer2.cCharFile[i*ALG_TZ_MB+j][0],Tz,ALG_SIZE_TZ);
            		SetFPMBIndexOne(wUserId*PER_MB_USER+i);
            		SaveUserFp(&gsCharBuffer2,wUserId);
            		return RT_OK;
            	}            	
            }   
        }         
    }     
	return RT_FAIL;
}
UINT8 GetUserFp(StruMBFile *p,UINT16 wUserId)
{
    if (wUserId>=USER_NUM)
        return PS_ADDRESS_OVER;
    if (gcpUserIndex[wUserId]!=1)
        return PS_READ_ERR;
	ReadFpMB_N((UINT8*)p,wUserId*PER_MB_USER,PER_MB_USER);
    giMBCounter=UserStatistics();
	return RT_OK;
}
UINT8 DeteleUser(UINT16 wUserId,UINT16 nNum)
{
    if (wUserId+nNum>USER_NUM)
        return RT_FAIL;
    ClearFPMBIndexN(wUserId*PER_MB_USER,nNum*PER_MB_USER);
    giMBCounter=UserStatistics();
    return RT_OK;
}
UINT8 DeteleUserAll(void)
{
    ClearFPMBIndexAll();
    giMBCounter=UserStatistics();
    return RT_OK;
}

UINT16 FPMBIndexToUserID(UINT16 wIndex)
{
    UINT16 wUserId;
    wUserId=wIndex/PER_MB_USER;
    return wUserId;
}

UINT16 UserIDToFPMBIndex(UINT16 wUserId)
{
	UINT16 wIndex;	
	UINT32 wIndextp;//ֹ65535
	wIndextp = PER_MB_USER * wUserId;
	if((wIndextp > 65525) || (wIndextp > FP_CAPACITY))
		wIndex = FP_CAPACITY;
	else
		wIndex = wIndextp;
	return wIndex;
}

UINT8 JudgeEnrollPara(UINT16 JuIDtemp, UINT8 JuGetMBNum, UINT8 JuStoreMode)
{
	UINT8 m;
	if(JuIDtemp >= USER_NUM)
		return PS_ADDRESS_OVER;
	if(JuGetMBNum > FP_PER_USER)
		return PS_TMPL_NUM_ERR;
	if((JuStoreMode & 0x01) == 0x00)//ڰλ򲻸
	{
		if(giMBCounter == FP_MB_MAX)
			return PS_LIB_FULL_ERR;
		for(m=0;m<PER_MB_USER;m++)
		{	    
			if(gcpMBIndex[(JuIDtemp*PER_MB_USER)+m] == 0x01)
				return PS_TMPL_NOT_EMPTY;
		}
	}
	return RT_OK;	
}

UINT8 JudgeIdentifyPara(UINT8 JuSecurityLV, UINT16 JuIDtemp)
{
	UINT8 m;
	UINT16 Summ = 0;
	if(giMBCounter == 0)
		return PS_LIB_EMPTY_ERR;
	if((JuIDtemp >= USER_NUM) && (JuIDtemp < 0xFFFF))
		return PS_ADDRESS_OVER;
	else if(JuIDtemp < USER_NUM)
	{
		for(m=0;m<PER_MB_USER;m++)
		{	    
			if(gcpMBIndex[(JuIDtemp*PER_MB_USER)+m] == 0x01)
				Summ++;
		}
		if(Summ == 0)
			return PS_TMPL_EMPTY;
	}
	switch(JuSecurityLV)
	{
		case 1:  gwMatchScore=22;break;
		case 2:  gwMatchScore=36;break;
		case 3:  gwMatchScore=50;break;
		case 4:  gwMatchScore=60;break;
		case 5:  gwMatchScore=70;break;
		default: gwMatchScore=50;break;
	}
	return RT_OK;	
}

UINT8 UserMbMergeFeature(UINT8 *pChar,UINT16 wUserId,UINT16 MbIndex,UINT8 MergeAll)
{
    UINT8 cRet;
    UINT8 Tz[ALG_SIZE_TZ];
    memcpy(Tz,pChar,ALG_SIZE_TZ);
    cRet=RT_FAIL;

    if (MergeAll==0)//ֻںϵǰ 
    {
        if (ReadFpMB((unsigned char* )&gsCharBuffer2,MbIndex)==RT_OK)
        {
        	if (MergeMb((UINT8*)&gsCharBuffer2, Tz)==RT_OK)
        	{
        		cRet=RT_OK;
        	}        	
        }
	    if (cRet==RT_OK)  
	    {
	    	cRet = WriteFpMB((unsigned char* )&gsCharBuffer2,MbIndex);
	    }         
    }  
    else
    {
        if (GetUserFp(&gsCharBuffer2,wUserId)==RT_OK)
        {
        	if (MergeMbA_N((UINT8*)&gsCharBuffer2,Tz,PER_MB_USER*ALG_TZ_MB )==RT_OK)
        	{
        		cRet=RT_OK;
        	}        	
        }  
	    if (cRet==RT_OK)  
	    {
	    	cRet = SaveUserFp(&gsCharBuffer2,wUserId);
	    }         
    } 
	 
    return  cRet;   	
}


//ģز 
void ClearFPMBIndexAll(void)
{
    memset(gcpMBIndex,0,FP_MB_MAX);//sizeof(gcpMBIndex));
	WriteFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
} 

UINT8 ClearFPMBIndexN(UINT16 wIndex,UINT16 num)
{
    if (wIndex+num>FP_MB_MAX)
        return RT_FAIL;
    memset(&gcpMBIndex[wIndex],0,num);
    WriteFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
	return RT_OK;
}

UINT8 SetFPMBIndexOne(UINT16 wIndex)
{
    if (wIndex>=FP_MB_MAX)
        return RT_FAIL;
    gcpMBIndex[wIndex]=1;
	WriteFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
	return RT_OK;
} 
UINT8 SetFPMBIndexN(UINT16 wSIndex,UINT16 IndexNum)
{
    UINT16 i;
    if (IndexNum<1)
        return RT_FAIL;
    if (wSIndex+IndexNum>FP_MB_MAX)
        return RT_FAIL;
    for (i=0;i<IndexNum;i++)
    {
    	gcpMBIndex[wSIndex+i]=1;
    }    
	WriteFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
	return RT_OK;
} 
/*************************************
һ²ָƴ洢߼ز 
**************************************/
//ȡָģ 
void GetFPMBIndex(void)
{
	ReadFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
} 
//ָģ 
void SaveFPMBIndex(void)
{
	WriteFlash(gcpMBIndex,FP_MBINDEX_SAVE_ADDR,FP_MB_MAX);//sizeof(gcpMBIndex));
} 
//ָǷЧ
//UINT16 wIndex: 
UINT8 CheckVaildFPMBIndex(UINT16 wIndex)
{
	if (wIndex>=FP_MB_MAX)
        return RT_FAIL;
    if (gcpMBIndex[wIndex]==1)
        return RT_OK;
    return RT_FAIL;
}
//ģز
/*ģҳ ˴ģС㷨ӦÿһģģΨһı*/
UINT8 ReadFpMB(unsigned char* pMBBuf,UINT16 Index)
{
    return ReadFlash(pMBBuf,START_MB_ADD+Index*ALG_SIZEOFMB,ALG_SIZEOFMB);
}

/*дģҳ ˴ģС㷨ӦÿһģģΨһı*/
UINT8 WriteFpMB(unsigned char* pMBBuf,UINT16 Index)
{
    return WriteFlash(pMBBuf,START_MB_ADD+Index*ALG_SIZEOFMB,ALG_SIZEOFMB);
}

/*ָģ*/
UINT8 ReadFpMB_N(unsigned char* pMBBuf,UINT16 Index,UINT8 num)
{
    return ReadFlash(pMBBuf,START_MB_ADD+Index*ALG_SIZEOFMB,ALG_SIZEOFMB*num);
}
/*дָģ*/
UINT8 WriteFpMB_N(unsigned char* pMBBuf,UINT16 Index,UINT8 num)
{
  //  print("ַ =%x \r\n",START_MB_ADD+Index*ALG_SIZEOFMB );
    return WriteFlash(pMBBuf,START_MB_ADD+Index*ALG_SIZEOFMB,ALG_SIZEOFMB*num);
}






