#include "SYglobal.h"


#if (SENSOR_CHOICE == FP300)
/**************************************************************
 Initial the GPIO which used to control the fingerprint sensor
**************************************************************/
void SensorPortInitial(void)
{
    GpioRegs.GPAPE.bit.GPA1 = 1;
    FPC_RSTDATA = 0x00;
    FPC_RSTUSE = 0x8;
    FPC_CSUSE = 0x8;
    //GPIO_BitPullClr(GPIOA,1);
}
/**************************************************************
--------------- Disable the sensor chip select ----------------
**************************************************************/
void DisCs(void)
{
    FPC_CSDATA = 0x01;
}
/**************************************************************
---------------- Enable the sensor chip select ----------------
**************************************************************/
void EnCs(void)
{
    FPC_CSDATA = 0x00;
}
/**************************************************************
------------- Give the sensor reset pin hige lever ------------
**************************************************************/
void SetRst(void)
{
    FPC_RSTDATA = 0x01;
}
/**************************************************************
------------- Give the sensor reset pin low lever -------------
**************************************************************/
void ResetRst(void)
{
    FPC_RSTDATA = 0x00;
}

extern U16 g_chip_id;
/**************************************************************
-------- Communication initail for fingerprint sensor ---------
**************************************************************/
void Re_ComInitial(void)
{
    U16 chip_id;
    chip_id = FPX_ChipId();
    STRUCT_SPI_FORMAT sSpiFormat;
    sSpiFormat.bMasterEn = MASTER;
    sSpiFormat.bBits = 0x08;
    sSpiFormat.bMode = MODE0;
    sSpiFormat.bFrame = MSB;

    switch(chip_id)
    {

    case CHIP_ID_iG102:
    case CHIP_ID_iG102A:
    case CHIP_ID_iG102B:
        sSpiFormat.lSckFreq = 24000000;
        break;
    default:
        sSpiFormat.lSckFreq = 12000000;
        break;
    }


    SPI_Init(FPC_SPIx,sSpiFormat,NULL,NULL);
}
/**************************************************************
-------- Communication initail for fingerprint sensor ---------
**************************************************************/
void ComInitial(void)
{
    STRUCT_SPI_FORMAT sSpiFormat;
    sSpiFormat.bMasterEn = MASTER;
    sSpiFormat.bBits = 0x08;
    sSpiFormat.bMode = MODE0;
    sSpiFormat.bFrame = MSB;
    sSpiFormat.lSckFreq = 12000000;

    SPI_Init(FPC_SPIx,sSpiFormat,NULL,NULL);
}





/**************************************************************
------------ Write Register value to fingerprint sensor -------------
**************************************************************/
//20170407 AlbertKe++
UINT8 SensorWriteReg(UINT8 bAddr, UINT8 bData)
{
    EnCs();
    SPI_RW(CMD_WRITE_REG|bAddr);
    SPI_RW(bData);
    DisCs();
    return 0;
}
/**************************************************************
------------ Read Register value from fingerprint sensor -------------
**************************************************************/
//20170407 AlbertKe++
UINT8 SensorReadReg(UINT8 bAddr, UINT8 *pbData)
{
    UINT8 Ret = RT_OK;

    EnCs();
    *pbData = 0x20|bAddr;
    Ret = SensorReadByte(pbData);
    Ret = SensorReadByte(pbData);
    DisCs();

    return Ret;
}

/**************************************************************
------------ Write One byte to fingerprint sensor -------------
**************************************************************/
UINT8 SensorWriteByte(UINT8 bData)
{
    return SpiWriteByte(FPC_SPIx,bData);
}
/**************************************************************
----------- Read One byte from fingerprint sensor -------------
**************************************************************/
UINT8 SensorReadByte(UINT8 *pData)
{
    return FPXReadByte(FPC_SPIx,pData);
//	return SpiTransceive(FPC_SPIx, pData);
}
/*************************************************************************
** Function    : SPI receive byte (not interrupt)
** Input       : UINT8 bSpiNum -- 	SPI number, SPI 0/1
** 				 UINT8 *pData --		The value to be received (pointer)
** Output      : UINT8	--			Return the result, RT_OK or RT_FAIL
**************************************************************************/
UINT8 FPXReadByte(UINT8 bSpiNum, UINT8 *pData)
{
    return SpiTransceive(bSpiNum, pData);
}


#endif
