/***************************************************************************************************
**  File name    :FPxx.c
**  Function     :
**  Author       :zougl
**  Data         :2013/10/14
**  Version      :V1.5
**  Description  :
**  Modify Record:
***************************************************************************************************/
#include "SYglobal.h"

#if (SENSOR_CHOICE == FP300)
#include "FAP10.h"
#include "Spi.h"
#include "Math.h"


#define MAXCHK(a,b) (a>b? (b) : (a))
#define MINCHK(a,b) (a<b? (b) : (a))
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))

SENSOR		sensor;
FPCONFIG 	*config;

volatile struct USART_REGS *gSpi = (FPC_SPIx==SPI1) ? &Spi1Regs:&Spi0Regs;

U8 g_SensorState = eSensorState_Sleep;
UINT8 g_cTest;
UINT16 g_chip_id;
UINT32 Flash_Run_Num;
UINT8  FPXDetectMode(void);
UINT8 FPXGetStatus(void);
void  FPXScanImage(void);
void FP_RegInit(void);
UINT8 FPXReadImage(UINT8 *pImageBuf,bool mode);
UINT8 FPXReadImage_IG101(UINT8 *pImageBuf,bool mode);
UINT8 FPXReadImage_ImgProcess(UINT8 *pImageBuf,bool mode);
void FPXReset(UINT8 mode);
UINT8 FPXReadOTP(void);
UINT16 FPX_ChipId(void);
#if JudgeImage==1
UINT8 JudgeImage_klz(int SrcX, int SrcY, UINT8 *DstImage,UINT8 *Dry_num,UINT8 *Wet_num);
#else
U8 kpi_get_touch_area(int SrcX,int SrcY,U8 *img,U8 *dry,U8 *wet,U8 *bg,U8 *fg,U8 *avg);
#endif

UINT8 FPXInit_Reg(void);
extern UINT16 CMOS_DetectFinger(UINT8 *pImage,UINT32 Width,UINT32 Height);

UINT8 NoOTP = 0;

Config_Reg cfg_reg;
Config_Reg *config_reg= &cfg_reg;


U8 NotePadMsg[32];
BOOL g_bHostResetSensor = FALSE; /**< TURE when host send rest sensor command */


/************************************************************************
@fn static void stc_LoadOTPData(FPCONFIG *cfg)
 Lpad OTP
@param  [in] :FPCONFIG *cfg 
               
@return  None
         None
*************************************************************************/

static void stc_LoadOTPData(FPCONFIG *cfg)
{
    OTP_CHIP_SERIAL_NUMBER      OTP_SN_3_0;
    OTP_CALI_DATA_3_0           OTP_CaliData_3_0;

    U8 *pOTP=(U8 *)&OTP_CaliData_3_0;
    U8 *pSNOTP = (U8 *)&OTP_SN_3_0;
    OTP_CONTROL *OTP = &sensor.OTP;

    U8 StartAddr, ModuleCalibAddr, ICCalibAddr, ReserveAddr;
    U8  chkSum0=0,chkSum1=0,chkSum2=0,chkSum3=0, i=0,reg1A,Tmp=0;

    if( NULL == OTP->OTPfn_ReadByte )
        return;

    //Continue to read OTP calibration data 3.0 area.
    //The physical OTP adress is Byte4~27.
    StartAddr=sizeof(OTP_CHIP_SERIAL_NUMBER);
    ICCalibAddr=sizeof(OTP_CaliData_3_0.CPDataByte) ;
    ModuleCalibAddr= sizeof(OTP_CaliData_3_0.CPDataByte) +  sizeof(OTP_CaliData_3_0.ICCalibDataByte);
    ReserveAddr = sizeof(OTP_CaliData_3_0.CPDataByte) +  sizeof(OTP_CaliData_3_0.ICCalibDataByte) +  sizeof(OTP_CaliData_3_0.ModuleCalibDataByte);

    for(i=0; i<sizeof(OTP_SN_3_0); i++)
    {
        OTP->OTPfn_ReadByte( i, pSNOTP);
//        printf("\r\nOTP Value: 0x%02X",*pSNOTP);
        chkSum0 += *pSNOTP;
    }


    for(i=0; i<sizeof(OTP_CALI_DATA_3_0); i++)
    {
        OTP->OTPfn_ReadByte(StartAddr + i, pOTP);
//         printf("\r\nOTP Value: 0x%02X",*pOTP);

        if(i < ICCalibAddr -1)
            chkSum1 += *pOTP;
        else if( (i >= ICCalibAddr) && (i < ModuleCalibAddr-1))
            chkSum2 += *pOTP;
        else if( (i >= ModuleCalibAddr) && (i < ReserveAddr -1))
            chkSum3 += *pOTP;
        pOTP++;
    }
    chkSum1 = ~(chkSum0 + chkSum1);
    chkSum2 = ~chkSum2;
    chkSum3 = ~chkSum3;

    if(OTP_CaliData_3_0.CPTrim.Checksum == chkSum1)
    {                     
        cfg->Reg6 = (OTP_CaliData_3_0.CPTrim.CurrentTrim<<3) | OTP_CaliData_3_0.CPTrim.QPTrim;
        cfg->Reg4 =  (cfg->Reg4&0xC0)| (OTP_CaliData_3_0.CPTrim.V1P8Trim<<3) | OTP_CaliData_3_0.CPTrim.V2P4Trim;
        cfg->Reg18 =  (cfg->Reg18&0xC0)| OTP_CaliData_3_0.CPTrim.OSCTrim;
        if(OTP_CaliData_3_0.CPTrim.stVRTrim.VRTrimIndex.Bit7 == 1)
               cfg->Reg5 = (cfg->Reg5 & 0xF8)|(OTP_CaliData_3_0.CPTrim.stVRTrim.VRTrimIndex.Bit6_0 & 0x07) ;
    }
    if(OTP_CaliData_3_0.ICCalibData.Checksum == chkSum2)
    {                     
        cfg->Reg2 = (cfg->Reg2 & 0x3C) | ((OTP_CaliData_3_0.ICCalibData.Gain>>2)<<6) | (OTP_CaliData_3_0.ICCalibData.Gain & 0x03);
        cfg->Reg1A = (cfg->Reg1A & 0x03) | (OTP_CaliData_3_0.ICCalibData.DCOffset<<2);
    }
    
    if(OTP_CaliData_3_0.ModuleCalibData.Checksum == chkSum3)
    {                     
        cfg->Reg2 = (cfg->Reg2 & 0x3C) | ((OTP_CaliData_3_0.ModuleCalibData.Gain>>2)<<6) | (OTP_CaliData_3_0.ModuleCalibData.Gain & 0x03);
		//cfg->Reg1A = (cfg->Reg1A & 0x03) | (OTP_CaliData_3_0.ModuleCalibData.DCOffset<<2);
        Tmp = OTP_CaliData_3_0.ModuleCalibData.DCOffset;
        //Tmp += 0x04;
        cfg->Reg1A = (cfg->Reg1A & 0x03) | (Tmp<<2);
        
    }
   

}


/**
@fn void FP_ReadOTPByte_VEM32(U8 uByteAddr, U8  *uByteData)
Read OTP data byte from assiged address, OTP type is total size 32Bytes.
@param  [in]    uByteAddr   Address wihch want to read out
@param  [out]   *uByteData  Read out data value
@return None
*/
void FP_ReadOTPByte_VEM32(U8 uByteAddr, U8 *uByteData)
{
    OTP_CONTROL *OTP = &sensor.OTP;
    U8 uWLNum = uByteAddr / 4;
    U8 uBLNum = uByteAddr % 4;
    U8 regCtrl,ubytedata;

    SensorReadReg((OTP->regCtrl),&regCtrl);
    regCtrl&= (~OTP->regCtrlMask);

    //Rst Low, Prog Low,CEB high,standby mode
    SensorWriteReg(OTP->regCtrl, regCtrl | OTP->chipStandby);
    //FP_WriteRegSingle(OTP->regWdat, uWLNum & OTP->regWdatMask); //Byte address, uWLNum[2:0]
    SensorWriteReg(OTP->regAddr, (uWLNum & OTP->regWdatMask) | ((uBLNum<<3)&OTP->regAddrMask)); //Bit number, uBLNum[4:0]

    //read mode
    SensorWriteReg(OTP->regCtrl, regCtrl | OTP->chipReadAccess);

    //read acess mode
    SensorWriteReg(OTP->regCtrl, regCtrl | OTP->chipRstPhs);
    _delay_us(1);    //SPEC. define Trsq > 100nS, Currently delay 1uS.
    //read mode
    SensorWriteReg(OTP->regCtrl, regCtrl | OTP->chipReadAccess);

    SensorReadReg(OTP->regRdat,&ubytedata); //read OTP data @ reg7
    *uByteData =  ubytedata;   //read OTP data @ reg7

    SensorWriteReg(OTP->regCtrl, regCtrl | OTP->chipStandby);


}



void OTP_Setting(void)
{

    OTP_CONTROL *OTP = &sensor.OTP;


    OTP->size			     = OTP_BYTE_SIZE;
    OTP->regAddr		     = REG_RG_OTP_ADDR_BIT;       /* 0x1C */
    OTP->regAddrMask         = REG_OTP_ADDR_MASK;         /* 0xF8 */
    OTP->regRdat	         = REG_RD_OTP_dtat;           /* 0x1E */
    OTP->regRdatMask         = REG_OTP_RDAT_MASK;         /* 0xFF */
    OTP->regCtrl		     = REG_RG_OTP_CTRL;           /* 0x1D */
    OTP->regCtrlMask         = REG_OTP_CTRL_MASK;         /* 0x0F */
    OTP->regWdat		     = REG_RG_OTP_ADDR_BIT;       /* 0x1C */
    OTP->regWdatMask         = REG_OTP_WDAT_MASK;         /* 0x07 */

    OTP->chipStandby         = ((~BIT_OTP_RST & ~BIT_OTP_PPROG) | BIT_OTP_CEB) & REG_OTP_CTRL_MASK;    // ceb=high, rst=low,  prg=low, standby mode
    OTP->chipRstPhs          = (~BIT_OTP_CEB & ~BIT_OTP_PPROG & BIT_OTP_RST) & REG_OTP_CTRL_MASK;      // ceb=low,  rst=high, prg=low
    OTP->chipReadAccess      = (~BIT_OTP_CEB & ~BIT_OTP_PPROG & ~BIT_OTP_RST) & REG_OTP_CTRL_MASK;     // ceb=low,  rst=low,  prg=low, read mode
    OTP->chipProgramAccess   = ((~BIT_OTP_CEB & ~BIT_OTP_RST) | BIT_OTP_PPROG) & REG_OTP_CTRL_MASK;    // ceb=low,  rst=low,  prg=high

    OTP->OTPfn_ReadByte      = FP_ReadOTPByte_VEM32;


}

/**
@fn static void stc_FP_SleepMode(U8 a_OnOff)
Sensor sleep mode enable\disable function.
@param  [in] a_OnOff   \c Enable(1) to enable \c Disable(0) to disable
@return None
*/
void FP_SleepMode(U8 a_OnOff)
//static void FP_SleepMode(U8 a_OnOff)
{
    U8 reg;

    SensorReadReg(REG_PAGE,&reg);
    reg &= 0xFC;
    SensorWriteReg(REG_PAGE,reg);
    _delay_ms(20);

    reg |= 0x04;
    SensorWriteReg(REG_PAGE,  reg);
}


/**
@fn static void stcFPCalculateHistoInfo2FD(ptIMGPREPROS_INFO ap_ImgPreInfo, U16 aImgWidth, U16 aImgHeight)
Calculate mean, std, max and min information for finger detection function.
@param  [in]    *cfg  Finger print sensor register value.
@return None
*/
static void stcFPCalculateHistoInfo2FD(ptIMGPREPROS_INFO ap_ImgPreInfo, U16 aImgWidth, U16 aImgHeight)
{
    U32 i;
    ptIMGPREPROS_INFO p_myImgPreInfo = ap_ImgPreInfo;
    U32 Temp=0;
    U16 MyHistSize = 128;
    U16 ImgSize = aImgWidth*aImgHeight;


    //Finger detection data analysis
    //Calculate mean of full image.
    Temp=0;
    for(i=0; i<MyHistSize; i++)
    {
        Temp += i * p_myImgPreInfo->Histogram[i];
    }
    p_myImgPreInfo->Mean = Temp/ImgSize;

    //Calculate STD
    Temp=0;
    for(i=0; i<MyHistSize; i++)
    {
        Temp += p_myImgPreInfo->Histogram[i]*abs(i-p_myImgPreInfo->Mean)*100;
    }
    p_myImgPreInfo->STD = Temp/ImgSize;

    //Calculate min of full image data.
    Temp=0;
    for(i=0; i<MyHistSize; i++)
    {
        Temp += p_myImgPreInfo->Histogram[i];
        if(Temp >=10)
        {
            p_myImgPreInfo->Min = i;
            break;

        }
    }

    //Calculate max of full image data.
    Temp=0;
    for(i=0; i<MyHistSize; i++)
    {
        Temp += p_myImgPreInfo->Histogram[MyHistSize-1-i];
        if(Temp >=10)
        {
            p_myImgPreInfo->Max = MyHistSize-1-i;
            break;

        }
    }

}


/**
@fn static U8 stc_FP_FingerStableCheck(void)
Check finger on sensor stable or not.
@return \c TRUE if finger stable. \c FALSE if finger no stable.
*/
U32 g_FDCount = 0;
static U8 stc_FP_FingerStableCheck(void)
{
    U16  histogram[128];

    U8 uRet = OFF;
    U8 st = 0;
    U32 ImgeReadCnt = 0;
    U16 pxCntChk=0;
    U32 j, totalpixel;
    U8 reg, Reg09_Orig;
    U8 PixData;
    IMGPREPROS_INFO myImgPreInfo[2];
    U8 FrameNum   = 0;
    U16 ImgWidth  = 192;
    U16 ImgHeight = 256,num=0;

#define _FGON_THRESHOLD_STD_    60//70
#define _FGON_THRESHOLD_MEAN_   100//115
#define _FGON_DIFF_STD_         20
#define _FGON_DIFF_MEAN_        2


    memset( &myImgPreInfo, 0x00, sizeof(myImgPreInfo));
    SensorReadReg(0x09,&Reg09_Orig);
    reg = (Reg09_Orig&0xE0)|0x05;
    SensorWriteReg(0x09, reg);

    for( FrameNum=0; FrameNum<2; FrameNum++)
    {
        FPXReset(SOFT_RESET) ;

        EnCs();
        SPI_RW(CMD_START_SCAN);
        DisCs();

        while(1)
        {
            if(FPXGetStatus()&BIT_FIFO_FULL_IG)
                break;
            _delay_us(10);

            if(num>=0xFFFF)
                return RT_CMOS_ERR;
            num++;
        }

        totalpixel = ImgWidth*ImgHeight;
        ImgeReadCnt = 0;
        pxCntChk = 0;

        EnCs();
        SensorWriteByte(CMD_READ_PIXELDATA);
        for (j=0; j<  totalpixel; j++)
        {
            ImgeReadCnt++;
            pxCntChk++;

            if( pxCntChk == 64)
            {
                pxCntChk = 0;
                st = 0;
                PixData  = SPI_RW(CMD_READ_STATUS);
                histogram[PixData/2] ++;
                myImgPreInfo[FrameNum].Histogram[PixData/2]++;

                if(ImgeReadCnt< totalpixel)
                    while(1)
                    {
                        st = SPI_RW(CMD_READ_STATUS);
                        if( st == 0xFF )
                            continue;
                        if((st & BIT_FIFO_FULL_IG) == BIT_FIFO_FULL_IG)
                        {
                            break;
                        }
                        if( TRUE == g_bHostResetSensor )
                            break;
                    }

                SPI_RW(CMD_READ_PIXELDATA);
            }
            else
            {
                PixData = SPI_RW(CMD_READ_PIXELDATA);
                histogram[PixData/2] ++;
                myImgPreInfo[FrameNum].Histogram[PixData/2]++;
            }

        }
        DisCs();

        //Finger detection data analysis
        stcFPCalculateHistoInfo2FD(&myImgPreInfo[FrameNum], ImgWidth, ImgHeight);

        //Finger ON judgement.
        if( myImgPreInfo[FrameNum].STD < _FGON_THRESHOLD_STD_ )
        {
            break;
        }

        if( (myImgPreInfo[0].Mean < _FGON_THRESHOLD_MEAN_ ) &&
                (myImgPreInfo[1].Mean < _FGON_THRESHOLD_MEAN_ ) )
        {
            if( (abs(myImgPreInfo[0].Mean - myImgPreInfo[1].Mean) <= _FGON_DIFF_MEAN_ ) &&
                    (abs(myImgPreInfo[0].STD - myImgPreInfo[1].STD) <= _FGON_DIFF_STD_ ) )
                uRet = ON;
        }
    } //for( FrameNum=0; FrameNum<2; FrameNum++)

    SensorWriteReg(0x09, Reg09_Orig);

    FPXReset(SOFT_RESET) ;
    return uRet;
}



/**
@fn static U8 stc_FP_FingerDetectTouchIC(void)
Enable finger detection mode and wait for finger put-on sensor by touch IC hardware
@return \c TRUE if finger ON. \c FALSE if finger OFF.
*/
extern BOOL g_bSensorInit;
static U8 FP_FingerDetect(void)
{
    U8 uRet = OFF;
//    U8 DETCTLState = 0;
    U32 ulTouchTimeout=0;
    U8 uStableCheckTime = 3;



    while(uStableCheckTime--)
    {
        uRet = stc_FP_FingerStableCheck();
        if( ON == uRet )
            break;
    }



    return uRet;
}


/***************************************************************************************************
** Subroutine  : FPXPortInit
** Function    : Configure compinRstNCSN
** Input       : None
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/

UINT8 FPXPortInit(void)
{
    UINT8 ret=RT_OK;

    SensorPortInitial();//rst cs signal congiure as output
    ComInitial();

    return ret;
}
/***************************************************************************************************
** Subroutine  : FPXInit
** Function    : Configure compinRstNCSN
** Input       : None
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/

UINT8 FPXInit(void)
{
    UINT8 ret=RT_OK;

    SensorPortInitial();//rst cs signal congiure as output
    ComInitial();
    _delay_ms(1);
    ResetRst();
    DisCs();
    FPXReset(GPIO_RESET);

    Chip_iGSelect();
    Re_ComInitial();
    _delay_ms(1);
    ResetRst();
    DisCs();
    FPXReset(GPIO_RESET);

    OTP_Setting();
    FPXInit_Reg();
    FP_RegInit();

    FPXReset(SOFT_RESET);
    NoOTP = 0;

    return ret;
}
/***************************************************************************************************
** Subroutine  : FPXReadReg
** Function    : FPXReadReg
** Input       : NONE
** Output      : NONE
** Description : Read chip register value
** Date        :
** ModifyRecord:
***************************************************************************************************/
void FPXReadReg(void)
{
    UINT16 cnt;
    UINT8 Reg[22]= {0};
    UINT8 wData;

    for(cnt=0; cnt<0x1F; cnt++)
    {
        EnCs();
        wData = CMD_READ_REG|cnt;
        SensorReadByte(&wData);
        SensorReadByte(&Reg[cnt]);
        DisCs();

//        printf("\r\n REG%02X: 0x%02X",cnt, Reg[cnt]);
    }



}
/***************************************************************************************************
** Subroutine  : FPX_ChipId
** Function    : FPX_ChipId
** Input       : NONE
** Output      : RT_OK/RT_FAIL
** Description : The test chip id no.
** Date        :
** ModifyRecord:
***************************************************************************************************/
UINT16 FPX_ChipId(void)
{
    UINT8 cTemp;
    UINT16 chipid;

    EnCs();
    cTemp = 0x20;
    SensorReadByte(&cTemp);
    cTemp = 0x21;
    SensorReadByte(&cTemp);
    chipid = (cTemp << 8);
    cTemp = 0x00;
    SensorReadByte(&cTemp);
    chipid += cTemp;
    DisCs();

    return chipid;
}
/***************************************************************************************************
** Subroutine  : FPXReset
** Function    : start fingerprint image scan
** Input       : None
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/
void FPXReset(UINT8 mode)
{
    if(mode==SOFT_RESET)
    {
        EnCs();
        SensorWriteByte(0xC0);
        DisCs();
    }
    else
    {
        ResetRst();
        _delay_ms(2); //Delay(300);
        SetRst();
        _delay_ms(2); //Delay(300);
    }
}


void FP_RegInit(void)
{
    U16 chip_id;
    FPCONFIG *cfg = &sensor.config;

    chip_id = FPX_ChipId();
    switch(chip_id)
    {

        case CHIP_ID_iG102:
        case CHIP_ID_iG102A:
        case CHIP_ID_iG102B:

        EnCs();
        SensorWriteByte(CMD_WRITE_REG|REG_AFE_CONTROL);
        SensorWriteByte(cfg->Reg2);
        SensorWriteByte(cfg->Reg3);
        SensorWriteByte(cfg->Reg4);
        SensorWriteByte(cfg->Reg5);
        SensorWriteByte(cfg->Reg6);
        SensorWriteByte(cfg->Reg7);
        SensorWriteByte(cfg->Reg8);
        SensorWriteByte(cfg->Reg9);
        DisCs();

        EnCs();
        SensorWriteByte(CMD_WRITE_REG|REG_RST_DELAY);
        SensorWriteByte(cfg->RegB);
        SensorWriteByte(cfg->RegC);
        SensorWriteByte(cfg->RegD);
        DisCs();

        EnCs();
        SensorWriteByte(CMD_WRITE_REG|REG_RG_DIG_RSV);
        SensorWriteByte(cfg->Reg10);
        SensorWriteByte(cfg->Reg11);
        SensorWriteByte(cfg->Reg12);
        SensorWriteByte(cfg->Reg13);
        SensorWriteByte(cfg->Reg14);
        SensorWriteByte(cfg->Reg15);
        SensorWriteByte(cfg->Reg16);
        SensorWriteByte(cfg->Reg17);
        SensorWriteByte(cfg->Reg18);
        SensorWriteByte(cfg->Reg19);
        SensorWriteByte(cfg->Reg1A);
        SensorWriteByte(cfg->Reg1B);
        DisCs();

        EnCs();
        SensorWriteByte(CMD_WRITE_REG|0x1D);
        SensorWriteByte(cfg->Reg1D);
        DisCs();

        EnCs();
        SensorWriteByte(CMD_WRITE_REG|0x1F);
        SensorWriteByte(cfg->Reg1F);
        DisCs();

        break;
    }


//debug   FPXReadReg();
}


/***************************************************************************************************
** Subroutine  : FPXInit_Reg
** Function    : Configure compinRstNCSN
** Input       : None
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/

UINT8 FPXInit_Reg(void)
{
    U16  chip_id ;
    FPCONFIG *cfg = &sensor.config;


    chip_id = FPX_ChipId();
    switch(chip_id)
    {    

        case CHIP_ID_iG102:
        case CHIP_ID_iG102A:
        case CHIP_ID_iG102B:

        cfg->Reg0 		= 0xF1;
        cfg->Reg1 		= 0x31;
        cfg->Reg2 		= 0xA5;
        cfg->Reg3 		= 0x52;
        cfg->Reg4		= 0x64;
        cfg->Reg5		= 0x8C;
        cfg->Reg6		= 0x7C;
        cfg->Reg7 		= 0x20;
        cfg->Reg8 		= 0xA4;
        cfg->Reg9 		= 0x8B;
        cfg->RegA 		= 0x0;
        cfg->RegB 		= 0x2D;
        cfg->RegC 		= 0x1C;
        cfg->RegD 		= 0x09;

        cfg->Reg10 		= 0x0C;
        cfg->Reg11 		= 0x00;
        cfg->Reg12 		= 0x0D;//0x10;
        cfg->Reg13 		= 0x00;
        cfg->Reg14 		= 0x11;
        cfg->Reg15 		= 0x02;//0x03;
        cfg->Reg16 		= 0x03;
        cfg->Reg17 		= 0x49;
        cfg->Reg18 		= 0x45;
        cfg->Reg19 		= 0x40;
        cfg->Reg1A 		= 0x81;//0x9D;//0x5D;//0x9D;//0x5D;
        cfg->Reg1B 		= 0x00;
        cfg->Reg1D 		= 0x00;
        cfg->Reg1F 		= 0xCB;
        cfg->testpin 	= 3;            	// test pin config
        cfg->bufbias 	= 2;            	// buffer bias
        cfg->options 	= 0x03;            	// bit 0: auto-offset
        break;

    }

    stc_LoadOTPData(cfg);

    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : ImageRst
** Function    : make 160*160 image show on 256*288
** Input       : Img addr
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/

void ImageRst(UINT8 *pImageBuf, int x, int y, int SrcX, int SrcY)
{
    UINT8 AverageX = (SrcX - x)/2;
    UINT8 AverageY = (SrcY - y)/2;
    int j = 0;
    int i = 0;
    j = y-1;
    for(i = (SrcY - 1); i >= 0; i--)
    {
        if((i >= AverageY)&&(i <= (SrcY -AverageY)))
        {
            memset(pImageBuf + i*SrcX, 0xff, AverageX);
            //memcpy(pImageBuf + i*SrcX +AverageX, (pImageBuf - 0x400) + j*x, x);
            memcpy(pImageBuf + i*SrcX +AverageX, pImageBuf + j*x, x);
            memset(pImageBuf + i*SrcX + SrcX-AverageX, 0xff, AverageX);
            j--;
        }
        else
            memset((pImageBuf) + i*SrcX, 0xff, SrcX);
    }
}





/*****************************************************************************
@fn		VarTemp_KPI
@brief
@param[IN]
@return
*******************************************************************************/
static U32 VarTemp_KPI(U8 refer, int img_w, int img_h, U8 *pBlk)
{
    U8 *ptr = pBlk;
    U32 variance = 0;
    U32 blk_w = img_w / 8;//VALUE_KPI;
    U32 blk_h = img_h / 8;//VALUE_KPI;

    int j = 0, i = 0;
    for (j = 0; j<blk_h; j++)
    {
        for (i = 0; i<blk_w; i++)
        {
            U8 px = *ptr;
            U16 delta = (px > refer) ? (px - refer) : (refer - px);
            variance += (delta * delta);
            ptr++;
        }

        ptr = ptr + img_w - blk_w;
    }

    variance = variance / (blk_h*blk_w);
    return variance;

}


/*****************************************************************************
@fn		get_image__hist
@brief
@param[IN]
@return
@Kevin 20200202
*******************************************************************************/



U8 get_image_hist( int img_w, int img_h,U8 *img)
{
    int i, j;
    U8 *ptr = img+(130*256),avg=0,avgcolumn=0,avgcolumn3=0,num=0;
    U32 dwAvgLine=0,dwAvgColumn=0,dwAvgColumn3=0;

    for (j = 0; j<100; j++)
    {
        for (i = 0; i<img_w; i++,ptr++)
        {
            if(i==0)
                dwAvgColumn+= *ptr;

            if(i==1)
                dwAvgColumn3+= *ptr;

            dwAvgLine += *ptr;

        }
        avg=(dwAvgLine/img_w);

        if( avg>=190||avg==0x00)        // check white line or black line
            num++;
        dwAvgLine=0;

    }

    avgcolumn3=(dwAvgColumn3/100);
    avgcolumn=(dwAvgColumn/100);
//     if((avgcolumn3-avgcolumn)>=40||(avgcolumn>240))
//      return RT_FAIL;
// printf("\n\ravg=%d,AvgColm3=%d,AvgColm=%d,num=%d,AvgColm3-AvgColm=%d",avg,avgcolumn3,avgcolumn,num,abs(avgcolumn3-avgcolumn) );

    //if(abs(avgcolumn3-avgcolumn)>=30||(avgcolumn>240))
//     if(avgcolumn3-avgcolumn<=10||(avgcolumn>240))
//       return RT_FAIL;
//

    if (num<10)
        return RT_OK;
        
    return RT_FAIL;
}


#define KPI_VALUE 10

const int KPI_VALID_AREA =50;// 70;//(52/5)      //(max:64/4)
const int KPI_VALID_AREA_MIN = 35;	//(52/5)      //(max:64/4)
const int KPI_VALID_AREA_MAX = 80;	//(52/5)      //(max:64/4)

static U8 get_hist(int img_w, int img_h, U8 *img, U8 *BG, U8 *FG)
{
    int i, j;
    U8 *ptr = img;
    U32 sum, target;
    U8 ret = 1;

    int blk_w = img_w / KPI_VALUE;
    int blk_h = img_h / KPI_VALUE;
    U16 hist[256] = { 0 };

    for (j = 0; j<blk_h; j++)
    {
        //memcpy(blk + j*blk_w, ptr, 16);
        for (i = 0; i<blk_w; i++)
        {
            hist[*ptr]++;
            ptr++;
        }

        ptr = ptr + img_w - blk_w;
    }

    target =40;// 35;//(blk_w*blk_h) / 10;
    //target = (blk_w*blk_h) / 3;

    sum = 0;
    for (i = 255; i >= 0; i--)
    {
        sum += hist[i];
        if (sum > target)
            break;
    }
    if (BG) *BG = i;

    sum = 0;
    for (i = 0; i <= 255; i++)
    {
        sum += hist[i];
        if (sum > target)
            break;
    }
    if (FG) *FG = i;


    ret = 0;

    //exit:
    return ret;
}

/*****************************************************************************
@fn			get_touch_area
@brief		get touch area
@param[IN]
@return		touch area % (0~100)
*/
U8 kpi_get_touch_area(
    int SrcX,
    int SrcY,
    U8 *img,
    U8 *dry,
    U8 *wet,
    U8 *bg,
    U8 *fg,
    U8 *avg
)
{
//	U32 i, j;
//	U8 area = 0;
//	U16 blk_w = SrcX / KPI_VALUE;
//	U16 blk_h = SrcY / KPI_VALUE;

    *avg= get_image_hist(SrcX,SrcY,img);

//	for (i = 0; i < KPI_VALUE*KPI_VALUE; i++ )//64
//	{
//		j = i / KPI_VALUE;
//		int num = i%KPI_VALUE;
//		U8 *pBlk = (img + j*blk_h*SrcX + num*blk_w);
//		U8 background, foreground;
//		get_hist(SrcX, SrcY, pBlk, &background, &foreground);

//		//if (VarTemp_KPI(background, SrcX, SrcY, pBlk) >0x200)// KPI_VERVAL)
//		if ((background - foreground) > 35)
//			area++;
//	}

//    if (area>KPI_VALID_AREA)
//         *avg= get_image__hist(SrcX,SrcY,img);


    return *avg;// area;
}

UINT8 Prepare_chang_Image(unsigned char *image)
{
    UINT32 hist[256] = {0},m,k;
	UINT32 i,j;
	for(i = 0;i<256*360;i++)
	{
		hist[image[i]]++;
	}
	m=0;
	for(i = 0;i < 256;i++)  //ȡСֵ
	{
		m += hist[i];
		if(m > 10000)
			break;
	}
	m = 0;
	for(j = 255;j > 0;j--)	//ȡСֵ
	{
		m += hist[j];
		if(m > 20000)
			break;
	}
	j=j-((j-i)/3);			//㴰
	
	if(j > (i + 30))
	{
		for(m = 0;m < 256*360;m++)
		{
			k =image[m];
			if(k < i)
				k = 0;
			else if(k > j)
				k = 0xFF;
			else 
			{
				k = ((k-i) << 8) / (j - i);
			}
			if(k > 255)
				image[m] = 0xff;
			else 
				image[m] = (k & 0xff) ;
		}
	}
	else
	{
		memset(image,0xff,256*360);
	}
		return RT_FAIL;
	return RT_OK;
} 

/***************************************************************************************************
** Subroutine  : FPXGetImage
** Function    : GET image from fifo
** Input       : None
** Output      : 01
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/
#if IMAGE_GENCHAR_FLAG == 1
UINT8 cRet;
UINT8 ImageAreaDetect(UINT8 *pImg,UINT8 IsEnroll);
UINT8 ImageControl(UINT8 *pImg,UINT8 IsEnroll);
#endif

UINT8 FPXGetImage(bool mode)
{
    UINT8 val=0;
    UINT8 *pImageBuf = (UINT8 *)(IMG_BUF);
    UINT8 *avg;


#if IMAGEPROCESS==1
        if(RT_OK != FPXReadImage_ImgProcess(pImageBuf, mode))
            return FG_FAIL;

#else
     
        if(RT_OK != FPXReadImage(pImageBuf, mode))
            return FG_FAIL;
#endif             


#if JudgeImage==1  // AREA CHECK
    val = JudgeImage_klz(256,360,(void*)IMG_BUF,NULL,NULL);
#else
    UINT8 Status;
    Status=get_image_hist(256,360,(void*)IMG_BUF);
    if ( Status==RT_OK)
        val = 0x00;        
    else
        val = 0x01;
     
#endif
     
    if(val == 0x00)
    {
    
#if IMAGE_BINARY    // Ʀ
      Prepare_chang_Image((void*)IMG_BUF);
#endif     
        ImageRst((void*)IMG_BUF,256,360,256,360);

        return FG_OK;
    }
    else
    {
        memset(pImageBuf,0x00,256*360);
        return FG_FAIL;
    }

}


/***************************************************************************************************
** Subroutine  : FPXGetStatus
** Function    : get the status of reg
** Input       :
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/


UINT8 FPXGetStatus()
{
    UINT8 statu;

    EnCs();
    SensorWriteByte(0x03);
    statu = 0x00;
    SensorReadByte(&statu);
    DisCs();

    return statu;
}

void FP_SetChannelOFSData(U8 *pRX)
{
    U8 i = 0, reg4;
    reg4 = SensorReadReg(REG_VLDO_TRM,&reg4);

    SensorWriteReg(REG_VLDO_TRM,  reg4| 0x40);//enable calib_en

    /*for(i = 0; i < 8; i++)
          FP_WriteRegSingle(REG_CALIB_OFS, 0x20);
    for(i = 8; i < 16; i++)
          FP_WriteRegSingle(REG_CALIB_OFS, 0x20);
    for(i = 16; i < 24; i++)
          FP_WriteRegSingle(REG_CALIB_OFS, 0x20);
    for(i = 24; i < 32; i++)
          FP_WriteRegSingle(REG_CALIB_OFS, 0x20);    */
    for(i = 0; i < 32; i++)
        SensorWriteReg(REG_CALIB_OFS, pRX[i]);
    SensorWriteReg(REG_VLDO_TRM, reg4 & 0xBF);//disable calib_en
}


/**
@fn static U8 FP_AutoGainAdjust(UINT8 *pImageBuf)
Gain adjust function.
This function need a 32*256 = 8KBytes temp buffer.
@return \c TRUE if finger on and adjust finished. \c FALSE if no finger.
*/
static UINT8 FP_AutoGainAdjust(UINT8 *pImageBuf)
{
    #define TEST_10V    1
    
    U8 LoopCnt = 10;
    U8 bFGStatus = FALSE;
    //16 level of gain setting from 0x0F (minimum) to 0x00 (maximum)
    
    U8 GainArray[16] = {0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, \
                        0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00};
    U8 GainReg0x02, GainValue;
    U16 wHistogram[256];
#if(0) //Need to do this if this stc_FP_AutoGainAdjust() function removed out from stc_FP_ReadImageData()                        
    U8 Reg0x0D, Reg0x1D;
#endif                        
    U8 ChannelNum = 32;
    S16 i, j;
    U8 WCnt, WPoint=0, BCnt, BPoint=0;
    U8 Contrast, BlackScale;
    S16 GainStep=0;
    U8 num=0;
    U8 *RawImageBuffer = pImageBuf;
    U8 MaxiToggle, MiniToggle;
#define FGON_THRESHOLD  30
#define BLACK_HIGH      50    
#define BLACK_LOW       30 
    
    
    
#if(0) //Need to do this if this stc_FP_AutoGainAdjust() function removed out from stc_FP_ReadImageData()
    SensorReadReg(REG_RG_OTP_CTRL, &Reg0x1D);
    //Disable touch_ctl bit to disable touch function.
    SensorWriteReg(REG_RG_OTP_CTRL, (Reg0x1D & 0xCF));
    _delay_ms(1);
    //Switch metal bezel sinal to sensor scan signal.
    SensorReadReg(REG_INT_HD_DELAY, &Reg0x0D);
    SensorWriteReg(REG_INT_HD_DELAY, (Reg0x0D | 0x80));
    _delay_ms(1);    
#endif

    //Read 1 subframe to check finger and adjust gain setting.
    MaxiToggle=0;
    MiniToggle=0;
    while(LoopCnt-- > 0)
    {
        memset(RawImageBuffer, 0x00, 256*32);
        memset(wHistogram, 0x00, sizeof(wHistogram) );

        EnCs();
        SensorWriteByte(CMD_SOFTWARE_RESET);
        SensorWriteByte(CMD_START_SCAN);
        DisCs();  
        
        num=0;
        while(1)
        {
            if(FPXGetStatus()&BIT_FIFO_FULL)
                break;
            _delay_us(100);

            if(num>=0xFF)
                return RT_FAIL;
            num++;
        }
        
        EnCs();
        for( i=0; i<ChannelNum; i++ )
        {
            SPI_RW(CMD_BURSTREAD_PIXELDATA_256);
            for(j = 0 ; j < 256 ; j++)
            {
                RawImageBuffer[i*256+j] = SPI_RW(CMD_DUMMY);
            }//for j
        }//for i
        DisCs();
        
        //Calculate Histogram of 6+2 lines.
        for( i=2; i<30; i+=5 )
        {
            for( j=38; j<218; j++) //width 180
            {
                wHistogram[ RawImageBuffer[256*i+j] ]++;
            }//for j
        }//for i
        for( i=30; i<=31; i++ )
        {
            for( j=38; j<218; j++) //width 180
            {
                wHistogram[ RawImageBuffer[256*i+j] ]++;
            }//for j
        }//for i

        //Calculate contrast
        BCnt = 0;
        for(i=0; i<256; i++)
        {
            BCnt += wHistogram[i];
            if(BCnt >= 100 )
            {
                BPoint = i;
                break;
            }
        }
        WCnt = 0;
        for(i=255; i>=0; i--)
        {
            WCnt += wHistogram[i];
            if(WCnt >= 100 )
            {
                WPoint = i;
                break;
            }
        }
        SensorReadReg(REG_AFE_CONTROL, &GainReg0x02);
        GainValue = (GainReg0x02&0x03) | ((GainReg0x02>>6)<<2);
        Contrast = WPoint-BPoint;
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "GainValue_C=0x%02X\n",GainValue);        
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "Contrast=%d\n",Contrast);
        if( Contrast<FGON_THRESHOLD )
        {
            bFGStatus=FALSE;
            break;
        }
        BlackScale = BPoint;
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "BlackScale=%d\n",BlackScale);
        if( (BlackScale>=BLACK_LOW)&&(BlackScale<=BLACK_HIGH) )
        {
            bFGStatus=TRUE;
            break;
        }
        SensorReadReg(REG_AFE_CONTROL, &GainReg0x02);
        GainValue = (GainReg0x02&0x03) | ((GainReg0x02>>6)<<2);
        for(i=0; i<16; i++)
        {
            if( GainValue == GainArray[i] )
            {
                GainStep = i;
                break;
            }
        }
        
        if( BlackScale>BLACK_HIGH )
        {
            if( (GainStep += 2)>15 )
            {
                GainStep=15;
                MaxiToggle++;
            }
        }
        else //(Contrast>CONTRAST_HIGH)
        {
            if( (GainStep -= 1)<0 )
            {
                GainStep=0;
                MiniToggle++;
            }
        }
        if( ((2==MaxiToggle)||(2==MiniToggle)) || \
            ((GainValue == GainArray[15])&&(BlackScale>BLACK_HIGH)) )
            
        {
            bFGStatus=TRUE;
            break;
        }
        GainValue = GainArray[GainStep];
        GainReg0x02 = (GainReg0x02&0x3C) | ((GainValue>>2)<<6) | (GainValue&0x03);
        SensorWriteReg(REG_AFE_CONTROL, GainReg0x02);
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "GainValue_U=0x%02X\n",GainValue);
        
    }//while

#if(0) //Need to do this if this stc_FP_AutoGainAdjust() function removed out from stc_FP_ReadImageData()    
    SensorWriteReg(REG_INT_HD_DELAY,  Reg0x0D);
    SensorWriteReg(REG_RG_OTP_CTRL,  Reg0x1D);
#endif
    return bFGStatus;
}

/***************************************************************************************************
** Subroutine  : FPXScanImage
** Function    : start fingerprint image scan
** Input       : None
** Output      : None
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/
void FPXScanImage()
{
    EnCs();
    SensorWriteByte(0x02);
    DisCs();
}




#define RBUFFER_SIZE	256*2
UINT8 DummyLineRingBuffer[RBUFFER_SIZE] = { 0 };
UINT16 RBufferIdx = 0;
static BOOL DummyLineCopy(UINT8* aSrc, UINT16 aSize)
{
	BOOL bRet = FALSE;
	
	if (aSize > RBUFFER_SIZE)
		return (bRet);
	memcpy(&DummyLineRingBuffer[0], aSrc, aSize);
	RBufferIdx = 0;

	return (bRet = TRUE);
}


static  UINT8 DummyLineRead(void)
{
	UINT8 Data = 0;

	Data = DummyLineRingBuffer[RBufferIdx];
	RBufferIdx = (++RBufferIdx) % (RBUFFER_SIZE);

	return Data;
}

BOOL IsSetRXOfs = FALSE;

UINT8 FPXReadImage_ImgProcess(UINT8 *pImageBuf,bool mode)
{
#define _AUTO_GAIN_         1
#define _IMG_FILTER_        1
#define _MOVEMENT_CHK_      1

    const U16 RawLineMappingArray[12][30] =
    {
        {0, 12, 24, 36, 48, 60, 72, 84, 96, 108, 120, 132, 144, 156, 168, 180, 192, 204, 216, 228, 240, 252, 264, 276, 288, 300, 312, 324, 336, 348},
        { 11, 23, 35, 47, 59, 71, 83, 95, 107, 119, 131, 143, 155, 167, 179, 191, 203, 215, 227, 239, 251, 263, 275, 287, 299, 311, 323, 335, 347, 359 },
        { 1, 13, 25, 37, 49, 61, 73, 85, 97, 109, 121, 133, 145, 157, 169, 181, 193, 205, 217, 229, 241, 253, 265, 277, 289, 301, 313, 325, 337, 349 },
        { 10, 22, 34, 46, 58, 70, 82, 94, 106, 118, 130, 142, 154, 166, 178, 190, 202, 214, 226, 238, 250, 262, 274, 286, 298, 310, 322, 334, 346, 358 },
        { 2, 14, 26, 38, 50, 62, 74, 86, 98, 110, 122, 134, 146, 158, 170, 182, 194, 206, 218, 230, 242, 254, 266, 278, 290, 302, 314, 326, 338, 350 },
        { 9, 21, 33, 45, 57, 69, 81, 93, 105, 117, 129, 141, 153, 165, 177, 189, 201, 213, 225, 237, 249, 261, 273, 285, 297, 309, 321, 333, 345, 357 },
        { 3, 15, 27, 39, 51, 63, 75, 87, 99, 111, 123, 135, 147, 159, 171, 183, 195, 207, 219, 231, 243, 255, 267, 279, 291, 303, 315, 327, 339, 351 },
        { 8, 20, 32, 44, 56, 68, 80, 92, 104, 116, 128, 140, 152, 164, 176, 188, 200, 212, 224, 236, 248, 260, 272, 284, 296, 308, 320, 332, 344, 356 },
        { 4, 16, 28, 40, 52, 64, 76, 88, 100, 112, 124, 136, 148, 160, 172, 184, 196, 208, 220, 232, 244, 256, 268, 280, 292, 304, 316, 328, 340, 352 },
        { 7, 19, 31, 43, 55, 67, 79, 91, 103, 115, 127, 139, 151, 163, 175, 187, 199, 211, 223, 235, 247, 259, 271, 283, 295, 307, 319, 331, 343, 355 },
        { 5, 17, 29, 41, 53, 65, 77, 89, 101, 113, 125, 137, 149, 161, 173, 185, 197, 209, 221, 233, 245, 257, 269, 281, 293, 305, 317, 329, 341, 353 },
        { 6, 18, 30, 42, 54, 66, 78, 90, 102, 114, 126, 138, 150, 162, 174, 186, 198, 210, 222, 234, 246, 258, 270, 282, 294, 306, 318, 330, 342, 354 },
    };    
    U8 DummyLineBuffer[2][256]; //Line30, 31 data buffer per-subframe.
    U8 *RawImageBuffer = pImageBuf;
    U32 totalpixel = (U32)(32*256*12);
    U16 ChannelNum = 32;
    U16 SubFrame = 12;
    U16 Selnum;
	U8 reg0D, reg18, reg1D;
    U8 st=0, num=0;
    U32 i, j, pxCnt=0;
    S16 idpX;
    U8 bRet = RT_OK; 
    

    
#if(_IMG_FILTER_)    
    S16 FilterAvgThd;
    U16 CntNum, GraySumR3, GraySumL3;
    S16 AvgR3, AvgL3, GrayDiff;
    U8 RefMin, RefMax;
    S16 idpY, TmpPxl;
#endif //_IMG_FILTER_
    U8 bFGStatus = FALSE;
#if(_MOVEMENT_CHK_)
	st_subFrameSimilarityChk MySubFrameChk0_11, MySubFrameChk0_6;
	U8 SubFrameNum;
    float fThreshold = 0;
    float fSimDiff = 0;
#endif //_MOVEMENT_CHK_
    UINT16 RescanCnt = 0;
    //For performance log
    unsigned long ullT1=0, ullT2=0, ullT3=0, ullT4=0, ullT5=0, ullT6=0, ullT34Sum=0;
    
    
    SensorReadReg(REG_OSC,&reg18);
    SensorWriteReg(REG_OSC, (reg18 | BIT_EN_OSC | BIT_EN_CHIP));
    //_delay_ms(1);

    SensorReadReg(REG_RG_OTP_CTRL,&reg1D);
    SensorWriteReg(REG_RG_OTP_CTRL,  (reg1D & 0xCF));
    //_delay_ms(1);

    SensorReadReg(REG_INT_HD_DELAY,&reg0D);
    SensorWriteReg(REG_INT_HD_DELAY,  reg0D | 0x80);
    //_delay_ms(1);

    RescanCnt = 0;
RESCAN:
    
    ullT34Sum = 0;
    
    if(RescanCnt++ > 10 )
    {
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RescanCnt>10\n");
        
        bRet = RT_FAIL;
        goto FUNC_END;
    }
    
    //SysTick_Config(SCM_GetSysClk()/1000);
    //ullT1 = GetSysTick();    
#if(_AUTO_GAIN_)
    bFGStatus = FP_AutoGainAdjust(pImageBuf);
    //ullT2 = GetSysTick();
    
    if( FALSE == bFGStatus )
    {
        bRet = RT_FAIL;
        goto FUNC_END;
    }
#endif //_AUTO_GAIN_
    
 
    
    pxCnt = 0;
    
    EnCs();
    SensorWriteByte(CMD_SOFTWARE_RESET);
    DisCs();
    _delay_ms(5);
    EnCs();
    SensorWriteByte(CMD_START_SCAN);
    DisCs();
    
    num = 0;
    while(1)
    {
        if(FPXGetStatus()&BIT_FIFO_FULL)
            break;
        _delay_us(50);

        if(num>=0xFF)
        {
            if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RT_FAIL1\n");
            bRet = RT_FAIL;
            goto FUNC_END;
        }
        num++;
    }

    EnCs();
    for(Selnum = 0 ; Selnum < SubFrame ; Selnum++)
    {
        for( i=0; i<ChannelNum-2; i++ )
        {
            SPI_RW(CMD_BURSTREAD_PIXELDATA_256);
        #if(1)            
            for(j = 0 ; j < 256 ; j++)
                RawImageBuffer[RawLineMappingArray[Selnum][i]*256+j] = SPI_RW(CMD_DUMMY);
        #else //Debug only     
            for(j = 0 ; j < 128 ; j++)
                RawImageBuffer[RawLineMappingArray[Selnum][i]*256+j] = SPI_RW(CMD_DUMMY);
            //Backup left side 128 images data to right side for debugging.
            for(j = 0 ; j < 128 ; j++)
                RawImageBuffer[256*(30*Selnum+i)+(128+j)] = SPI_RW(CMD_DUMMY);
            memcpy(&RawImageBuffer[256*(30*Selnum+i)+128], &RawImageBuffer[RawLineMappingArray[Selnum][i]*256], 256/2);
        #endif            
        }
        //Read 30th, 31th dummy line data.
        for( i=0; i<2; i++ )
        {
            SPI_RW(CMD_BURSTREAD_PIXELDATA_256);
            for(j = 0 ; j < 256 ; j++)
                DummyLineBuffer[i][j] = SPI_RW(CMD_DUMMY);
        }        
        pxCnt += 32*256;
        
#if(_IMG_FILTER_)
        //Check 10 point of 1st column and filter out black and white pixel.
       // ullT3 = GetSysTick();
        GraySumR3 = 0;
        GraySumL3 = 0;
        CntNum = 0;
        FilterAvgThd = -5; //Threshold to do gray pixel adjustment.
        RefMin = 255;
        RefMax = 0;
        
        for( idpY=0; idpY<30; idpY+=1)
        {           
            //Calculate gray scale
            for( idpX=0; idpX<3; idpX++)
            {
                GraySumL3 += RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX];
                GraySumR3 += RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX + 3];
                CntNum++;
                //Search maximum\minimum pixel of reference line.
                if( RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX + 3] > RefMax )
                    RefMax = RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX + 3];
                if( RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX + 3] < RefMin )
                    RefMin = RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX + 3];
            }
        } //for idpY
        
        AvgL3 = GraySumL3/CntNum;
        AvgR3 = GraySumR3/CntNum;
        GrayDiff = AvgL3-AvgR3;
        
        //if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RESCAN_2:0[%d][%d-%d=%d], Min=%d, Max=%d\n", Selnum, AvgL3, AvgR3, GrayDiff, RefMin, RefMax);
        if( GrayDiff < FilterAvgThd )
        {
            if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RESCAN_2_T\n");
            if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RESCAN_2:0[%d][%d-%d=%d], Min=%d, Max=%d\n", Selnum, AvgL3, AvgR3, GrayDiff, RefMin, RefMax);
            for( idpY=0; idpY<30; idpY+=1)
            {
                for( idpX=0; idpX<3; idpX++)
                {
                    TmpPxl = RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX] - GrayDiff;
                    TmpPxl = MAXCHK( TmpPxl, RefMax);
                    TmpPxl = MINCHK( TmpPxl, RefMin);
                    RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX] = TmpPxl;
                    //Debug start
                    #if(0)
                    RawImageBuffer[256*(30*Selnum+idpY)+128+6+idpX] = RawImageBuffer[256*RawLineMappingArray[Selnum][idpY] + idpX];
                    RawImageBuffer[256*(30*Selnum+idpY)+128+12+idpX] = Selnum*20;
                    #endif
                    //Debug end                    
                } //idpX
            } // idpY
        }

        for(idpY=0; idpY<30; idpY++)
        {
            RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+2] = ( RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+3]*3 + RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+2]*7 )/10;
            RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+1] = ( RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+2]*3 + RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+1]*7 )/10;
            RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]] = ( RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+1]*7 + RawImageBuffer[256*RawLineMappingArray[Selnum][idpY]+2]*3 )/10;
        }
        
        //ullT4 = GetSysTick();
        ullT34Sum += (ullT4-ullT3);
#endif //_IMG_FILTER_
        
        //Check fifo status when every 8192Bytes(32*256) data read end.
        if(pxCnt %(32*256) == 0)
        {          
            if( pxCnt < (totalpixel - 256) )
            {
                num = 0;
                SPI_RW(CMD_READ_STATUS);
                while(1)
                {
                    st = SPI_RW(CMD_READ_STATUS);
                    if( st == 0xFF ) 
                        continue;
                    if((st & BIT_FIFO_FULL_IG) == BIT_FIFO_FULL_IG)
                        break;
                    
                    if(num++>=0xFF)
                    {
                        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RT_FAIL1\n");
                        return RT_FAIL;
                    }
                    _delay_us(50);
                }
            }
        }
    } //for Selnum
	DisCs();

#if (_MOVEMENT_CHK_)
    //ullT5 = GetSysTick();
  
    //Check image similarity
    fThreshold=0.985;//0.988; //Threshold to control similarity
    fSimDiff = 0.003;//0.002;
 	memset(&MySubFrameChk0_11, 0x00, sizeof(MySubFrameChk0_11));
    memset(&MySubFrameChk0_6, 0x00, sizeof(MySubFrameChk0_6));
    
	//Step 1. Calculate similarity of subframe 0 and 11.
	for (i = 0; i < 2; i++)
	{
		if (0 == i)
			SubFrameNum = 0;
		else
			SubFrameNum = 11;
		for (j = 0; j < 30; j++) //Ignore line30,31 
		{
			//Calculate Full line data
			for (idpX = 0; idpX < 256; idpX++)
			{
				MySubFrameChk0_11.uiHistogram[i][ RawImageBuffer[256 * RawLineMappingArray[SubFrameNum][j] + idpX] ] += 1;
				MySubFrameChk0_11.iHistogramPxlNum[i]++;
			} //idpX
		} //for j                
	} //for i

	for (i = 0; i < 256; i++)
	{
		//Calculate Full line data
		MySubFrameChk0_11.uiHistogram[0][i] = (MySubFrameChk0_11.uiHistogram[0][i]*1000000)/MySubFrameChk0_11.iHistogramPxlNum[0];
		MySubFrameChk0_11.uiHistogram[1][i] = (MySubFrameChk0_11.uiHistogram[1][i]*1000000)/MySubFrameChk0_11.iHistogramPxlNum[1];        
		MySubFrameChk0_11.uiSimilarHist[i] = sqrt(MySubFrameChk0_11.uiHistogram[0][i]* MySubFrameChk0_11.uiHistogram[1][i]);
		MySubFrameChk0_11.uiTotalSimilar += MySubFrameChk0_11.uiSimilarHist[i];
	}
    MySubFrameChk0_11.flTotalSimilar = (float)MySubFrameChk0_11.uiTotalSimilar/1000000;
    
	//Step 2. Calculate similarity of subframe 0 and 6.
	for (i = 0; i < 2; i++)
	{
		if (0 == i)
			SubFrameNum = 0;
		else
			SubFrameNum = 6;
		for (j = 0; j < 30; j++) //Ignore line30,31 
		{
			//Calculate Full line data
			for (idpX = 0; idpX < 256; idpX++)
			{
				MySubFrameChk0_6.uiHistogram[i][ RawImageBuffer[256 * RawLineMappingArray[SubFrameNum][j] + idpX] ] += 1;
				MySubFrameChk0_6.iHistogramPxlNum[i]++;
			} //idpX
		} //for j                
	} //for i

	for (i = 0; i < 256; i++)
	{
		//Calculate Full line data
		MySubFrameChk0_6.uiHistogram[0][i] = (MySubFrameChk0_6.uiHistogram[0][i]*1000000)/MySubFrameChk0_6.iHistogramPxlNum[0];
		MySubFrameChk0_6.uiHistogram[1][i] = (MySubFrameChk0_6.uiHistogram[1][i]*1000000)/MySubFrameChk0_6.iHistogramPxlNum[1];        
		MySubFrameChk0_6.uiSimilarHist[i] = sqrt(MySubFrameChk0_6.uiHistogram[0][i]* MySubFrameChk0_6.uiHistogram[1][i]);
		MySubFrameChk0_6.uiTotalSimilar += MySubFrameChk0_6.uiSimilarHist[i];
	}
    MySubFrameChk0_6.flTotalSimilar = (float)MySubFrameChk0_6.uiTotalSimilar/1000000;    
    
    if(_RTT_PRINTF_)
    {        
        #define PRECISION 10000
        //int intPart, decimalPart;
        int intPart, decimalPart1, decimalPart2;
        
        intPart = (int) MySubFrameChk0_11.flTotalSimilar;
        decimalPart1 = (MySubFrameChk0_11.flTotalSimilar - intPart) * PRECISION;
        SEGGER_RTT_printf(0, "Similar0_11:F=%d.%d\n", intPart, decimalPart1);
        
        intPart = (int) MySubFrameChk0_6.flTotalSimilar;
        decimalPart2 = (MySubFrameChk0_6.flTotalSimilar - intPart) * PRECISION;
        SEGGER_RTT_printf(0, "Similar0_6:F=%d.%d\n", intPart, decimalPart2);        
    }
    
   //ullT6 = GetSysTick();
    if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "[P] AutoGain=%dms, Image Filter=%dms, MVChkTime=%dms\n", (ullT2-ullT1), ullT34Sum, (ullT6-ullT5) );    
    
    //kif( (MySubFrameChk0_11.flTotalSimilar < fThreshold ) ||\
    
    if( ((MySubFrameChk0_11.flTotalSimilar < fThreshold ) && (MySubFrameChk0_6.flTotalSimilar < fThreshold )) || \
        (fabs(MySubFrameChk0_11.flTotalSimilar - MySubFrameChk0_6.flTotalSimilar) > fSimDiff) )
    {
        if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "RESCAN_3\n");
        goto RESCAN;
    }
#endif //(_MOVEMENT_CHK_)
    bRet = RT_OK;
    
FUNC_END:
    
    SensorWriteReg(REG_OSC, reg18);
    SensorWriteReg(REG_INT_HD_DELAY,  reg0D);
    SensorWriteReg(REG_RG_OTP_CTRL,  reg1D);
    
    if(_RTT_PRINTF_) SEGGER_RTT_printf(0, "Done\n");
    
    return bRet;
}





//BOOL IsSetRXOfs = FALSE;

UINT8 FPXReadImage(UINT8 *pImageBuf,bool mode)
{
    U8 reg18 = 0, st = 0, reg0D, reg1D,num=0,bFGStatus;
    U16 usbSendCnt = 0;
    U32 i,j, pxCnt=0, totalpixel;
    volatile U32   t = 0,t1 = 0,t2 = 0;

    int  selnum = 0,pxCntChk = 0, totalPixel =Sub_Frame*Channel*256;
    UINT8 val;


    SensorReadReg(REG_OSC,&reg18);
    SensorWriteReg(REG_OSC, (reg18 | BIT_EN_OSC | BIT_EN_CHIP));
    _delay_ms(1);

    SensorReadReg(REG_RG_OTP_CTRL,&reg1D);
    SensorWriteReg(REG_RG_OTP_CTRL,  (reg1D & 0xCF));
    _delay_ms(1);

    SensorReadReg(REG_INT_HD_DELAY,&reg0D);
    SensorWriteReg(REG_INT_HD_DELAY,  reg0D | 0x80);
    _delay_ms(1);
    
    bFGStatus = FP_AutoGainAdjust(pImageBuf);
    if( FALSE == bFGStatus )
        return RT_FAIL;
    

    EnCs();
    SensorWriteByte(CMD_SOFTWARE_RESET);
    DisCs();
    _delay_ms(1);
    

    EnCs();
    SensorWriteByte(CMD_START_SCAN);
    DisCs();

    while(1)
    {
        if(FPXGetStatus()&BIT_FIFO_FULL)
            break;
        _delay_us(100);

        if(num>=0xFF)
            return RT_FAIL;
        num++;
    }

    EnCs();
    SPI_RW(CMD_BURSTREAD_PIXELDATA_256);//send cmd to get image data


    for(selnum = 0 ; selnum < Sub_Frame ; selnum++)
    {     
       for(i = 1 ; i <= Channel ; i++)
        {
            for(j = 0; j < 256; j++)
            {
                pxCntChk++;
                pxCnt++;
                if( pxCntChk == 256)
                {
                    pxCntChk = 0;
                    val = SPI_RW(CMD_READ_STATUS);

                    if((pxCnt+1)< totalPixel)
                        while(1)
                        {
                            st = SPI_RW(CMD_READ_STATUS);
                            if( st == 0xFF )
                                continue;
                            if((st & BIT_FIFO_FULL) == BIT_FIFO_FULL)
                                break;
                        }
                    SPI_RW(CMD_BURSTREAD_PIXELDATA_256);
                }
                else
                {
                    // val = SPI_RW(CMD_BURSTREAD_PIXELDATA_256);
                    val = SPI_RW(CMD_DUMMY);
                }

                //256x360
                if(i <= 30)   // ignore channel 31 32
                {
                    #if (IMAGE_FLIP_H==1) // Image Horizontal mirroring
					  
                        if(selnum %2 == 0) //SEL0,2....
                            pImageBuf[ 256*360- (256 * ((i - 1) *12 + ((selnum + 1) / 2)) + j) ] = val;
                        else //SEL1,3....
                            pImageBuf[256*360-(256 * (i *12 - (selnum + 1) / 2) + j) ] = val;
                        
                    #else                    
                        if(selnum %2 == 0) //SEL0,2....
                            pImageBuf[256 * ((i - 1) *12 + ((selnum + 1) / 2)) + j ] = val;
                        else //SEL1,3....
                            pImageBuf[256 * (i *12 - (selnum + 1) / 2) + j ] = val;
                    #endif        
                }
            }

        }
    }


    DisCs();

    SensorWriteReg(REG_OSC, reg18);
    SensorWriteReg(REG_INT_HD_DELAY,  reg0D);
    SensorWriteReg(REG_RG_OTP_CTRL,  reg1D);

    return RT_OK;

}





/***************************************************************************************************
** Subroutine  : BlockAverage
** Function    : ģƽֵ
** Input       : ģָͼ洢ַ
** Output      : ƽֵ
** Description :
** Date        : 2013.12.4
** ModifyRecord:
***************************************************************************************************/
UINT8 BlockAverage(int x,int y,int SrcX,int SrcY, UINT8 *addr,UINT8 *mini,UINT8 *BG,UINT8 *FG)
{
    UINT8 i;
    UINT8 j;
    UINT32 sum,t;
    UINT8 *ptr;
    UINT8 div;
    UINT16 Histogram[255] = {0x0};

    ptr = addr;
    sum = 0x00;
    *mini = *ptr;
    for(j=0; j<y; j++)     //average line  x = 32
    {
        for(i=0; i<x; i++) //average pixel y = 45
        {
            sum += *ptr ;
            if(*mini > *ptr)
                *mini = *ptr;
            Histogram[*ptr]++;
            ptr++;
        }

        ptr = ptr+SrcX-x ;
    }
    div =(UINT8)(sum/(x*y));

    t = (5*x*y)/100;
    j = 0;
    for(i = 0xFF; i > 10; i--)
    {
        j += Histogram[i];
        if(j > t)
            break;
    }
    *BG = i;
    j = 0;
    for(i = 0; i < 0xFF; i++)
    {
        j += Histogram[i];
        if(j > t)
            break;
    }
    *FG = i;

    return div;
}
/***************************************************************************************************
** Subroutine  : VarTemp
** Function    : ģķ
** Input       : ͬһģƽֵָͼ洢ַ
** Output      : 
** Description :
** Date        : 2013.12.4
** ModifyRecord:
***************************************************************************************************/
UINT32 VarTemp(UINT8 div,int SrcX, int SrcY, UINT8 *addr)
{
    UINT8 *ptr = addr;
    UINT32 temp = 0x00;
    UINT8 val = 0x00;
    int j = 0;
    int i = 0;
    for(j=0; j<SrcY/VALUE; j++)     //average line  x = 32
    {
        for(i=0; i<SrcX/VALUE; i++) //average pixel y = 45
        {
            if(*ptr >= div)
                val = *ptr - div;
            else
                val = div - *ptr;
            temp += (val * val);
            ptr++;
        }

        ptr = ptr+SrcX-SrcX/VALUE ;
    }
    temp = (temp/((SrcY/VALUE)*(SrcX/VALUE)) >>2 ) + 10;
    return temp;
}
/***************************************************************************************************
** Subroutine  : JudgeImage_klz
** Function    : жϸʪָ
** Input       : None
** Output      : 01
** Description :
** Date        : 2013.10.12
** ModifyRecord:
***************************************************************************************************/
UINT8 JudgeImage_klz(int SrcX, int SrcY, UINT8 *DstImage,UINT8 *Dry_num,UINT8 *Wet_num)
{
    int  num, flag = 0;
    UINT32 i,j;
    UINT8 *pBlock;
    UINT8 Average = 0;
    UINT8 Mini_Num = 0;
    UINT16 VarTab = 0;
    UINT8 BackGround,FrontGround,temp;
    UINT16 x,y;
    UINT16 VerVal = 0;
    UINT8 RangeOfFP = 0;

    x = SrcX/VALUE;
    y = SrcY/VALUE;

    for(i = 0; i < VALUE*VALUE; i++)
    {
        j = i/VALUE;
        num = i%VALUE;
        pBlock= (DstImage+j*y*SrcX+num*x);           //16ģ鸳ַ
        Average = BlockAverage(x, y, SrcX, SrcY,pBlock,&Mini_Num,&BackGround,&FrontGround);  //16ģƽֵ
        VarTab = VarTemp(Average,SrcX, SrcY, pBlock);        //16ģݷ
        temp = (BackGround - FrontGround);

        VerVal = (NoOTP == 1) ? 0x40 : VERVAL;
        if(VarTab > VerVal)
        {
            flag++;
            if(Dry_num != NULL)
            {
                if(temp < 0x30)
                    *Dry_num++;

            }
        }
        if(Wet_num != NULL)
        {
            temp = (temp / 5) << 1;//>> 2;  //ݾֵ
            if(Average < (FrontGround + temp))
                (*Wet_num)++;
        }
    }
    RangeOfFP = (NoOTP == 1) ? 0x3C : FGLIMIT_NUM;
    if(flag>= RangeOfFP)
        return 0;
    else
        return 1;
}

/***************************************************************************************************
** Subroutine  : FPXGetCapability
** Function    : Get sensor capabilities
** Input       : SENSOR_CAPABILITY_PTR
** Output      : RT_OK/RT_FAIL
** Description : Get sensor capabilities
** Date        :
** ModifyRecord:
***************************************************************************************************/
void FPXGetCapability(SENSOR_CAPABILITY_PTR apt_SensorCap)
{
    apt_SensorCap->Version = 1;
    apt_SensorCap->Width = SizeX;
    apt_SensorCap->Height = SizeY;
    apt_SensorCap->OTPSize = OTP_BYTE_SIZE;
}

/***************************************************************************************************
** Subroutine  : FPXGetImageByFileType
** Function    : pumps image data from FIFO and sends it to host
** Input       : None
** Output      : None
** Description :
** Date        : 2019.12.03
** ModifyRecord:
***************************************************************************************************/
UINT8 FPXGetImageByFileType(UINT8 *apImageBuf, UINT32 *apImgSizeLeft, UINT32 aSize2Read, UINT32 *apSizeReaded)
{
    UINT16 num=0;
    int i = 0, pxCntChk = 0;
    volatile UINT8 st;
    UINT32 whileCnt=0;


    //Only do once when 1st time to get image.
    if( SizeX*SizeY == *apImgSizeLeft )
    {
        FPXReset(SOFT_RESET);
        FPXScanImage();

        while(1)
        {
            if(FPXGetStatus()&0x40)
                break;

            _delay_us(10);

            if(num>=0xFFFF)
                return RT_CMOS_ERR;
            num++;
        }
        EnCs();
        SPI_RW(CMD_READ_PIXELDATA);//send cmd to get image data
    }

    pxCntChk=0;
    (*apSizeReaded)=0;
    for(i = 0; i <aSize2Read; i++)
    {
        pxCntChk++;
        EnCs();
        //if( pxCntChk == 256)      //
        if( pxCntChk == 64)
        {
            whileCnt = 0;
            pxCntChk = 0;
            apImageBuf[i] = SPI_RW(0x03);
            (*apImgSizeLeft)--;
            (*apSizeReaded)++;

            if( (*apImgSizeLeft) > 0 )
            {
                while(1)
                {
                    st = SPI_RW(0x03);
                    if( st == 0xFF )
                        continue;
                    if( (st&0x40)==0x40 )
                        break;
                    _delay_us(1);

                    if(whileCnt++>=1000)
                    {
                        DisCs();
                        return RT_CMOS_ERR;
                    }
                    //whileCnt++;
                }
            }
            //_delay_us(150);
            SPI_RW(CMD_READ_PIXELDATA);
        }
        else
        {
            apImageBuf[i] = SPI_RW(CMD_READ_PIXELDATA);
            (*apImgSizeLeft)--;
            (*apSizeReaded)++;
        }
    }//for

    if( 0 == *apImgSizeLeft )
    {
        DisCs();
    }

    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : FP_DETCtrlCheck
** Function    : Check touch function DETCTL pin.
** Input       : 1 0
** Output      : TRUE if DETCTL pin high (touch enable).
** Description :
** Date        :
** ModifyRecord:
***************************************************************************************************/
UINT32 g_uTimeout=0;
BOOL FP_DETCtrlCheck(void)
{
    BOOL bRet = FALSE;
    //Check DETCTRL pin to wait sensor ready from sleep mode.
    INT_USE = INPUT;
    g_uTimeout = 0;
    //_delay_ms(1000);
    if( 0 == INT_DATA )
    {
        while(g_uTimeout++ < 2000)
        {
            if( 1 == INT_DATA )
            {
                bRet = TRUE;
                _delay_ms(10);

                break;
            }
            _delay_ms(1);
        }
        if( 1 == g_uTimeout )
            ;//_delay_ms(190);
    }
    else
    {
        _delay_ms(10);
        bRet = TRUE;
    }
    return bRet;
}

/***************************************************************************************************
** end
***************************************************************************************************/
#endif
