#include "SYglobal.h"
//#include "bulkusb.h"
//#include "CtrlItem.h"
//#include "CtrlUsb.h"
//#include "UsbBase.h"
//#include "usbCont.h"
#include "USBProtocolX.h"

 
UINT8 gSysClkPar; 
UINT8 gUSBFlag = 0;
UINT8 gUSBSuspendMode = USB_SUSPENDED_8DIV_HFROSC;
UINT8 gUSBSuspendFlag = 0;
DoMyUSBSleepProc g_pDoMyUSBSleep=NULL;
UINT16 gIntrOut=0;
UINT16 gIntrIn=0; 

HANDLE_TO_INTERFACE *gpstUsbHandle;//Ϊָ,ΪɱUSBжģʽ ЭӿڵļԲô 
UINT8 gcUsbVld=0; 
/***************************************************************************************************
** Subroutine  : USBProtocolInit
** Function    : ͨѶʼ 
** Input       : HANDLE_TO_INTERFACE *p -- USBЭվ 
** Output      : 
** Description : Uart ӿڡʼ   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void USBProtocolInit(HANDLE_TO_INTERFACE *p)
{
	InitSCSICallBackFunc(512,MySCSICmd,NULL,NULL);
	InitUSBSleepCallBackFunc(USB_SUSPENDED_DIS,NULL);
	USB_Init(USB_MODE);	    
    gpstUsbHandle=p;
}

/***********************************************************************************
 * Subrountine:	USBDoWithPackage
 * Function:	Deal receive package from PC
 * Input:		None
 * Output:		None
 * Return:		None
 * Description:	
 * 				֧SetupΪжϷʽBulkΪѯʽ 
 * Date:		2013.03.28
 * ModifyRecord:
 **********************************************************************************/
void USB_DoWithPackage(void)
{ 
    UINT8 IntrUSB;
	UINT16 IntrIn;
	UINT16 IntrOut;
	
	UINT8 tmp = UsbRegs.INDEX;// ʱ棬ֹжϳbulk䵼indexı 
    IntrUSB = UsbRegs.INTRUSB.all; 
	IntrIn  = UsbRegs.INTRIN.all;
	IntrOut = UsbRegs.INTROUT.all; 

	if(gUsbMode==USB_SETUP_INT_MODE)
	{
		if(IntrIn>0)
		   gIntrIn |= IntrIn;      
		if(IntrOut>0)
		   gIntrOut |= IntrOut;
	} 
	   
	if(USB_MODE==USB_SETUP_INT_MODE)
	{
		gcUsbVld=0;
	}
 
	if(IntrUSB&M_INTR_SUSPEND)
    {
		if(gUSBSuspendMode == USB_SUSPENDED_8DIV_HFROSC)
		{
			gSysClkPar = USB_SUSPENDED | (UINT8)ScmRegs.SYSCLKCTRL.bit.FclkSel | ((ScmRegs.HFROSCCTRL.bit.HFROscGrade)<<4);
			SCM_SetSysClk((SYS_CLK)((ScmRegs.HFROSCCTRL.bit.HFROscGrade)<<4));	// run in HFROSC/8 system clock #endif
		}
		else if(gUSBSuspendMode == USB_SUSPENDED_32K)
		{
		   gUSBSuspendFlag = 1;
		}
		gUSBFlag = 1; 
    }  
	if(IntrUSB&M_INTR_RESUME)
    {
		if(gSysClkPar&USB_SUSPENDED)
		{
			gSysClkPar &= ~USB_SUSPENDED;
			SCM_SetSysClk((SYS_CLK)gSysClkPar);	// resume system clock 
		}
		gUSBFlag = 1; 
    }    
    
	if(IntrUSB&M_INTR_RESET) //reset
    {  
		if(gSysClkPar&USB_SUSPENDED)
		{
			gSysClkPar &= ~USB_SUSPENDED;
			SCM_SetSysClk((SYS_CLK)gSysClkPar);	// resume system clock 
		}
		USB_Reset(); 
		gUSBFlag = 1;   
    }
	if(IntrIn&M_INTR_EP0)// setup packet received
    {	     
        USB_SetupHandle(); 		      
    } 
 
    if((IntrOut&M_INTR_EP1)||(IntrOut&M_INTR_EP2)||(IntrOut&M_INTR_EP3))// OUT request received
    {   
	    if (USB_MODE!=USB_SETUP_INT_MODE) //жģʽѭģʽ   
    	{
        	USB_CBWHandle(); 
    	}            
    	else                               // Setup жд 
    	{
    		gcUsbVld=1;
    		UsbRegs.INDEX = tmp;
    	} 
    	//յݰ жģʽرUSBж,ֹûдЭͷӦָ 
        if (gpstUsbHandle->stPkgRec.cInterfaceTy==COMM_USB&&USB_MODE==USB_INTTERRUPT_MODE)
        {
        	NVIC_DisableIRQ(USB_IRQn);
        }             	
    }          
}

/***************************************************************************************************
** Subroutine  : USB_GetPkg
** Function    : USBЧݰȡЧݰ,ڲѯģʽ/SetUpжģʽ 
** Input       : 
** Output      : 
** Description :  
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void USB_GetPkg(void)
{
    if (USB_MODE==USB_SETUP_INT_MODE)//ֻSETUPжϷʽ 
    {
        if (gcUsbVld==1)
        {
        	USB_CBWHandle(); 
        }        
    }   
    else if (USB_MODE==USB_INTTERRUPT_MODE) //жϷʽ 
    {
    
    }   
    else if (USB_MODE==USB_POLLING_MODE) //ѯʽ 
    {
    	USB_DoWithPackage();
    }    
}
/***************************************************************************************************
** Subroutine  : USB_PkgInsRec
** Function    : յ CBW󣬽CBWݡ 
** Input       : PKG_RECVICE *p -- Э 
**               CBW* uCBW      -- CBW    
** Output      : 
** Description : Эָ 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
/*ָ*/
void USB_PkgInsRec(PKG_RECVICE *p,CBW* uCBW)
{
    UINT8 *cpRec;
    UINT32 i,j,dwLen;
    
    dwLen=uCBW->lCBWXferLength;
    cpRec=p->pInsBuf;
    USB_BulkReceive(cpRec,dwLen);
//    print_buf(cpRec,dwLen);
    i=0;
    while (i<dwLen)
    {
        if (cpRec[i]==PKG_HEAD_BYTE0&&cpRec[i+1]==PKG_HEAD_BYTE1) //Ұͷ 
        {
            dwLen=dwLen-i;
            for (j=0;j<dwLen;j++)
            {
            	cpRec[j]=cpRec[i+j];
            } 
            if (dwLen>COMM_PAKGE_LEN)// 2ͷ+4ַ+1ʾ+2 
            {
                p->wPkgLen=dwLen;
                p->cInterfaceTy=COMM_USB; 
                return;
            }             
            break;                  	
        }
        i++;        	
    } 
    return;
}
/***************************************************************************************************
** Subroutine  : USB_PkgDatRec
** Function    : յ CBW󣬽CBWݡ 
** Input       : PKG_RECVICE *p -- Э 
**               CBW* uCBW      -- CBW  
** Output      : 
** Description : Эݰ 
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void USB_PkgDatRec(PKG_RECVICE *p,CBW* uCBW)
{
    UINT8 *cpRec;
    UINT32 dwLen;

    dwLen=uCBW->lCBWXferLength;
    cpRec=p->pDtBuf;
    USB_BulkReceive(cpRec+p->dwDataOffset,dwLen);
    p->dwDataOffset+=dwLen;
    if (p->dwDataOffset>=p->dwDtLen)
    {
    	p->cPkgTy=COMM_INS;
    	p->cInterfaceTy=NO_COMM_WORK; 
    	
    }    

    return;
}

/***************************************************************************************************
** Subroutine  : USB_PkgInsRec
** Function    : յ CBW,豸ݺ 
**               CBW* uCBW   -- CBW  
** Output      : 
** Description :  
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void USB_PkgRec(CBW* uCBW)
{

	if (gpstUsbHandle->stPkgRec.cPkgTy==COMM_INS)
	{
		USB_PkgInsRec(&gpstUsbHandle->stPkgRec,uCBW);
	}	
	else if (gpstUsbHandle->stPkgRec.cPkgTy==COMM_DATA_REC||gpstUsbHandle->stPkgRec.cPkgTy==COMM_IMG_REC)
	{
		USB_PkgDatRec(&gpstUsbHandle->stPkgRec,uCBW);
	}
	
}

/***************************************************************************************************
** Subroutine  : USB_PkgInsRec
** Function    : յ CBW,豸ݡ 
**               CBW* uCBW   -- CBW  
** Output      : 
** Description :  
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
void USB_PkgSend(CBW* uCBW)
{
    PKG_SEND *psSendPkg;
    PKG_RECVICE *pRecPkg;
    
    pRecPkg=&gpstUsbHandle->stPkgRec;
    psSendPkg=&gpstUsbHandle->stPkgSend;
    
	switch (psSendPkg->cPkgTy)
    {
    	case COMM_INS:
            USB_BulkSend(psSendPkg->pInsBuf,uCBW->lCBWXferLength);
            break;
        case COMM_DATA_SEND:
        case COMM_IMG_SEND:
            USB_BulkSend(psSendPkg->pDtBuf+psSendPkg->dwDataOffset,uCBW->lCBWXferLength);
            psSendPkg->dwDataOffset+=uCBW->lCBWXferLength;
            if (psSendPkg->dwDataOffset>=psSendPkg->dwDtLen)
            {
            	pRecPkg->cPkgTy=COMM_INS;
    	        
            }        
            break;
        default:
            break;     
    }
    pRecPkg->cInterfaceTy=NO_COMM_WORK; 

}

void UsbPkgDat(PKG_SEND *psSendPkg)
{

    PKG_RECVICE *pRecPkg;
    
    pRecPkg=&gpstUsbHandle->stPkgRec;
    pRecPkg->cInterfaceTy=NO_COMM_WORK; 
    if (USB_MODE!=USB_POLLING_MODE) //ѯʽ 
    {
        NVIC_EnableIRQ(USB_IRQn);
        
        _nop();	
    }    
}
/***********************************************************************************
 * Subrountine:	USBBulkPoll
 * Function:	Deal bulk by polling mode
 * Input:		None
 * Output:		None
 * Return:		None
 * Description:	
 * 			 
 * Date:		2013.03.28
 * ModifyRecord:
 **********************************************************************************/
 void USB_BulkPoll(void)
 {
 	UINT32 status;

	status = NVIC->ISER[0]; 	// Save interrupt status
	NVIC_DisableIRQ(USB_IRQn); 	// disable SPI0 interrupt 
  	if(gUSBFlag == 1)
		gUSBFlag = 0; 
	NVIC->ISER[0] = status;		// recover interrupt status

	if(gIntrOut&M_INTR_EP1)// OUT request received
 	{ 
	    gIntrOut&=(~M_INTR_EP1);	 	 
 		USB_CBWHandle(); 	 		 				 
 	}
	else if(gIntrOut&M_INTR_EP2)// OUT request received
 	{ 
	    gIntrOut&=(~M_INTR_EP2);	 	 	 		 				 
 	}
	else if(gIntrOut&M_INTR_EP3)// OUT request received
 	{ 
	    gIntrOut&=(~M_INTR_EP3);	 	 	 		 				 
 	}
	else if(gIntrOut&M_INTR_EP4)// OUT request received
 	{ 
	    gIntrOut&=(~M_INTR_EP4);	 	 	 		 				 
 	}
 }

 /***********************************************************************************
* Subrountine:	USB_Handler
* Function:	    USB interrupt 
* Input:		None
* Output:		None
* Description:
* Date:		2013.03.28
* ModifyRecord:
**********************************************************************************/
void USB_Handler(void)
{
	 USB_DoWithPackage();
}
/***************************************************************************
* Subroutine:	InitUSBSleepCallBackFunc
* Function:		Init USB Sleep call back function and init USB suspend mode.
* Input:		bUSBSuspendMode- USB suspend mode.
*								#define	USB_SUSPENDED_DIS		  	0	
*								#define	USB_SUSPENDED_8DIV_HFROSC  	1	
*								#define	USB_SUSPENDED_32K 			2
*               pDoMyUSBSleep- the call back function for do with USB Sleep function.
* Output:		None;
* Description:	 
* Date:		2015.10.28
* ModifyRecord:
* *************************************************************************/  
void InitUSBSleepCallBackFunc(UINT8 bUSBSuspendMode,DoMyUSBSleepProc pDoMyUSBSleep)
{
	if(bUSBSuspendMode <= USB_SUSPENDED_32K)
	{
		gUSBSuspendMode = bUSBSuspendMode;
		if(bUSBSuspendMode == USB_SUSPENDED_32K)
			g_pDoMyUSBSleep = pDoMyUSBSleep;
	}
}

 /***********************************************************************************
* Subrountine:	USB_DoSuspend
* Function:	    USB  
* Input:		None
* Output:		None
* Description:
* Date:		2015.10.28
* ModifyRecord:
**********************************************************************************/
void USB_DoSuspend(void)
{
	UINT32 status;

	if(gUSBSuspendFlag)
	{
		status = NVIC->ISER[0]; 	// Save interrupt status
		NVIC_DisableIRQ(USB_IRQn); 	// disable SPI0 interrupt 
		gUSBSuspendFlag = 0;
		NVIC->ISER[0] = status;		// recover interrupt status
		if(g_pDoMyUSBSleep != NULL)
			g_pDoMyUSBSleep();	
	}	 
}

