#include "SyCBW.h"
#include "System.h"
#include "USBProtocolX.h"



/*---------------------------------------------------------------
Func: deal with the command that need to read data from device
Param:cdb-SCSI CDB command block;
return: 0-OK;
-----------------------------------------------------------------*/

UINT8 MyReadCmd(CBW* uCBW)
{	
	UINT8  nStatus;	

	USB_PkgSend(uCBW);			
	nStatus=USBS_PASSED; 
    SendCSWBack(uCBW,nStatus) ;				 
	return 0;
}

/*---------------------------------------------------------------
Func: deal with the command that need to write data to device
Param:cdb-SCSI CDB command block;
return: 0-OK;
-----------------------------------------------------------------*/
UINT8 MyWriteCmd(CBW* uCBW)
{    
	UINT8 nStatus;  
 	
    USB_PkgRec(uCBW);
    nStatus=USBS_PASSED;
	SendCSWBack(uCBW,nStatus) ;             
	return 0;       
}

/*---------------------------------------------------------------
Func: judge whether is our disk
Param:cdb-SCSI CDB command block;
return: 0-OK;
-----------------------------------------------------------------*/
UINT8 MyJudgeDisk(CBW* uCBW)
{
   UINT8 cpBuf[3];

   cpBuf[0]=0x55;
   cpBuf[1]=0x33;
   USB_BulkSend(cpBuf,2);    
   SendCSWBack(uCBW,USBS_PASSED);
   return 0;  
}
UINT8 MySCSICmd(CBW *uCBW)	
{
//    if(uCBW->CBWCB[0]!=0xEF) return RT_PARAM_ERR;//˵Զ
//
    switch(uCBW->CBWCB[0])
    {
        case CMD_READ:
              MyReadCmd(uCBW);
              break;	
        case CMD_WRITE:
              MyWriteCmd(uCBW);           
              break;	                   
        case CMD_JUDGEDISK:
             MyJudgeDisk(uCBW); 
             break;	
      default :
           return RT_FAIL;
      }    
    //SendCSWBack(uCBW,USBS_PASSED);  //20131024
	return RT_OK;
}
