/***************************************************************************************************
**  File name    : Protocol.h
**  Function     : do comm Protocol  parse data pakge, make daka pakge
**  Author       : yangf
**  Date         : 2013/12/17
**  Version      : v1.0
**  ModifyRecord : ֽݸֽǰֽں 0x1234 ˳Ϊ0x12 0x34
***************************************************************************************************/

#ifndef _PROTOCOL_H_
#define _PROTOCOL_H_

/***************************************************************************************************
** Include Header Files
***************************************************************************************************/
#include    "SY09.h"

/***************************************************************************************************
** Global Macro Definition
***************************************************************************************************/

//#define  USE_USB  
//#define  USE_UART  //modify by wayne 13:03 2011-1-27 
//#define  USE_I2C

/* ָŵַ */
#define COMM_PAKGE_LEN          9                               // ͷ 2ͷ+4ַ+1ʾ+2ݳ 
#define COMM_INS_BUF	        (UART_BUF)                    // շݰʼַ,/ݰʱʼַ
#define COMM_INS_PARA_BUF	    (UART_BUF+COMM_PAKGE_LEN)     // ݰʼַ,Ӧò㴦ָӦĲŵַ 
#define COMM_DATA_BUF	        (IMG_BUF)                       // ʾΪݰʱ,ݵĴŵַ(Ҫڷ) 
#define COMM_IMG_BUF	        (IMG_BUF)                       // շͼݰʱͼŵַ 

/* ͷͰʾ */
#define PKG_HEAD_BYTE0          0xef       // ͷ 
#define PKG_HEAD_BYTE1          0x01
#define PKG_HEAD                0x01ef     // ͷ 
#define PKG_DAT_FG              0x02       // ݰкݰ 
#define PKG_DAT_END_FG          0x08       // һݰ 
#define PKG_ACK_FG              0x07       // Ӧ 
#define PKG_INS_FG              0x01       // ָ,͵ָ 

/* ͨѶӿڶ */
#define NO_COMM_WORK            0           // ״̬ 
#define COMM_UART               1           // ͨѶӿΪUARTӿ 
#define COMM_USB                2           // ͨѶӿΪUSBӿ 
#define COMM_I2C                3           // ͨѶӿΪI2Cӿ 

/* ͨѶ״̬ */
#define COMM_INS                0           // ָӦ 
#define COMM_DATA_REC           1           // ͨݽ 
#define COMM_DATA_SEND          2           // ͨݷ 
#define COMM_IMG_REC            3           // ͼ 
#define COMM_IMG_SEND           4           // ͼ 

/* ͨѶ״̬ */	
#define	DO_OK     0 //ѾӦ 
#define	DO_WAIT   1 //ûжӦҪݱ־Ӧݰ 


/***************************************************************************************************
** Global Type Definition
***************************************************************************************************/


/*   ֽݸֽǰֽں 0x1234 ˳Ϊ0x12 0x34   */
#pragma pack(push) 	//״̬
#pragma pack(1)		//趨Ϊ1ֽڶ
/* ײӿ */ 
typedef struct _PKG_RECVICE{
    UINT8 cInterfaceTy;          // ӿ,ɽӿڸֵ
    UINT8 cPkgTy;                // յָͣ/ָ 
    UINT8 *pInsBuf;              // յİʼַ 
    UINT16 wPkgLen;              // 
    
    UINT8  *pDtBuf;              // ݰݵĴŵַ 
    UINT32 dwDtLen;              // Ҫյݵĳ
    UINT32 dwDataOffset;         // ƫƵַ 
    
}PKG_RECVICE;
typedef struct _PKG_SEND{
    UINT8 cInterfaceTy;          // ӿ,ɽӿڸֵ
    UINT8 cPkgTy;                // ݰͣӦ/ݰ/ͼ 
    
    UINT8 *pInsBuf;              // Ӧŵַ 
    UINT16 wPkgLen;              // 
    
    UINT8  *pDtBuf;              // ݰݵĴŵַ 
    UINT32 dwDtLen;              // Ҫ͵ݵĳ
    UINT32 dwDataOffset;         // ƫƵַ 
}PKG_SEND;

typedef struct _HANDLE_TO_INTERFACE{
    PKG_RECVICE stPkgRec;
    PKG_SEND    stPkgSend;
}HANDLE_TO_INTERFACE; 
/* Э */ 

/* Ӧò */ 
typedef struct _PKG_IN_APP{
    UINT8 *pPkg;                // յȷָ󴫵ݸӦò㣬ָ 
} PKG_IN_APP;

typedef struct _PKG_OUT_APP{    // Ӧòָݽṹ 
    UINT8 cDoStatus;
    UINT8 cACK;                  // ָ
    UINT8 *pata;                // Ӧ, ָ ͷԺ 
    UINT16 cpataLen;
    
    UINT8 cDatStus;             //Ҫݡݡ 
    UINT8 *pcDat;               //ݵַ 
    UINT32 dwDatLen;              //ݳ 
    UINT32 dwDataOffset;        // շƫƵַ 
} PKG_OUT_APP;

typedef struct _HANDLE_TO_APP{
    PKG_IN_APP  stInApp;
    PKG_OUT_APP stOutApp;
}HANDLE_TO_APP;

typedef struct _COMM_HANDLE{
    
    HANDLE_TO_INTERFACE stComInterFace; 
    HANDLE_TO_APP       stComApp;
    
    UINT8 *pInsBuf;             //
    UINT8 *pParaBuf;            //
    UINT8 *pDatBuf;             //
    UINT8 *pImgBuf;             //
    
    UINT8  cPwdVfyFg;           // Уͨ־ 
    UINT8  cInitItrfce;         // ʼ־ 
    UINT32 dwPktSize;           // ݳ 
    UINT32 dwCommPsd;           // ͨѶ 
    

}COMM_HANDLE;
#pragma pack(pop)//ָ״̬


/***************************************************************************************************
** Global Variable Declaration
***************************************************************************************************/
extern COMM_HANDLE gsCommHandle;
/***************************************************************************************************
** Global Functon 
***************************************************************************************************/

void ProtocolInit(void);
BOOL CmdChkCom(UINT8 *cpRecBuf);
UINT16 CmdGenCHK(UINT8 *cpRecBuf);
UINT8 PkgVfy(UINT8 *pCbuf);
UINT32 MakePackage(UINT8 *pIn,UINT8 *pOut,UINT32 wLen,UINT8 nType);
UINT32 MakePackageCpt(UINT8 *pIn,UINT8 *pOut,UINT32 wLen,UINT8 nType);
void GetDatFrompkg(UINT8 *pIn,UINT8 *pOut,UINT32 *pwLen);
void GetDatFrompkgCpt(UINT8 *pIn,UINT8 *pOut,UINT32 *pwLen);

 void PackageDatSend(PKG_SEND *psSendPkg);
void DoAppOut(PKG_OUT_APP *p);
UINT32 PackageDatRec(PKG_RECVICE *p);
void Get_Pkg(void);
UINT8 DoCommPkg(void);

#endif	
