#include "SYglobal.h"
#include "USBProtocol.h"
#include "SYFP.h"
#include "SY09_Device.h"
#include "System.h"
#include "UARTBase.h"

#ifdef IMD_MP_TEST
#include "MP_Test.h" 
#endif

extern void reset(void);


extern void UARTStdDataPkt(UINT16 wLen, UINT8 *cpSendData);
extern void UARTSendImage(UINT16 wLen, UINT8 *cpSendData);
extern void UARTStdAckPkt(UINT16 wLen,UINT8 *cpPara);
extern void DrawAllDots(UINT16 *wpBuf);
#ifdef IMD_NFC_M24SR_TAG_APPLIED
extern void DisableNFC(void);
extern void EnableNFC(void);
#endif
void SF125_Sleep (void);

UINT16 gnBufferID;
bool gbPwdPassed=0;

UINT8 flagCmd = 0;            //CMDִв־λ 
UINT8 whichCom = NO_COMM_WORK;//¼ͨѶӿ
#ifdef GENCHAR_SMALL_AREA
static UINT8 enrollGenCharcnt  = 0;   //ע
#endif
/***************************************************************************************************
** Subroutine  : DoCommand
** Function    : Ӧĺд 
** Input       : UINT8* cpBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָ 
** Output      : 
** Description : Uart ӿڡʼ  
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/

UINT8 DoCommand(UINT8* cpBuf,PKG_OUT_APP *psOutApp)
{
	static UINT8 nCommand;
	UINT8 cRet;

	if(flagCmd == 0)
		nCommand = cpBuf[9];

	switch(nCommand)
	{
/***************************************************************************************************/
		case PS_AutoEnroll:						//31-Զעģ 	
			cRet = CmdAutoEnroll(cpBuf,psOutApp);		
			break;
		case PS_AutoIdentify:					//32-Զָ֤ 	
			cRet = CmdAutoIdentify(cpBuf,psOutApp);		
			break;
		case PS_Sleep:							//33-˯ 	
			cRet = CmdSleep(cpBuf,psOutApp);		
			break;
		case PS_GetChipSN:							//34-Get chip SN 	
			cRet = CmdGetGhipSN(cpBuf,psOutApp);		
			break;
/***************************************************************************************************/
		case PS_GetImage:						//01-ȡͼ 	
			cRet = CmdGetImage(cpBuf,psOutApp);		
			break;
		case PS_GenChar:						//02- 
			cRet = CmdGenChar(cpBuf,psOutApp);
			break;
		case PS_Match:							//03-ȶ
			cRet = CmdMatch(cpBuf,psOutApp);
			break;
		case PS_Search:							//04-ָ 
			cRet = CmdSearch(cpBuf,psOutApp);
			break;
		case PS_RegModel:						//05-ϳģ 
			cRet = CmdRegModel(cpBuf,psOutApp);
			break;
		case PS_StoreChar:						//06-洢ģ 
			cRet = CmdStoreChar(cpBuf,psOutApp);
			break;
		case PS_LoadChar:						//07-ģ 
			cRet = CmdLoadChar(cpBuf,psOutApp);
			break;
		case PS_UpChar:							//08-ϴģ
			cRet = CmdUpChar(cpBuf,psOutApp);
			break;
		case PS_DownChar:						//09-ģ
			cRet = CmdDownChar(cpBuf,psOutApp);
			break;
		case PS_UpImage:						//0a-ϴͼ 
			cRet = CmdUpImage(cpBuf,psOutApp);
			break;
		case PS_DownImage:						//0b-ͼ  
			cRet = CmdDownImage(cpBuf,psOutApp);
			break;
		case PS_DeleteChar:						//0c-ɾģ 
			cRet = CmdDeleteChar(cpBuf,psOutApp);
			break;
		case PS_Empty:							//0d-ɾģ 
			cRet = CmdEmpty(cpBuf,psOutApp);
			break;
		case PS_WriteReg:
			cRet = CmdWriteReg(cpBuf,psOutApp);	//0e-ò
			break;
		case PS_ReadSysPara:
			cRet = CmdReadSysPara(cpBuf,psOutApp);//0f- 
			break;
		case PS_Enroll:
			cRet = CmdEnroll(cpBuf,psOutApp);  //10-עһöָ 
			break;
		case PS_Identify:
			cRet = CmdIdentify(cpBuf,psOutApp);//11-Զ֤ģ 
			break;
		case PS_SetPwd:
			cRet = CmdSetPwd(cpBuf,psOutApp);  //12-
			break;
		case PS_VfyPwd:
			cRet = CmdVfyPwd(cpBuf,psOutApp);      //13-У 
			break;
		case PS_GetRandomCode:
			cRet = CmdGetRandomCode(cpBuf,psOutApp);//14-ȡ
			break;
		case PS_SetChipAddr:
			cRet = CmdSetChipAddr(cpBuf,psOutApp);//15-õַ
			break;
		case PS_ReadINFpage:
			cRet = CmdReadINFpage(cpBuf,psOutApp);//16-ȡϢ
			break;
		case PS_Port_Control:
			cRet = CmdPortControl(cpBuf,psOutApp);//17-ͨѶ˿ڿ/ر
			break;
		case PS_WriteNotepad:
			cRet = CmdWriteNotepad(cpBuf,psOutApp);//18-д± 
			break;
		case PS_ReadNotepad:
			cRet = CmdReadNotepad(cpBuf,psOutApp);//19-± 
			break;
		case PS_BurnCode:
			cRet = CmdBurnCode(cpBuf,psOutApp);   //1a-
			break;
		case PS_HighSpeedSearch:
			cRet = CmdHighSpeedSearch(cpBuf,psOutApp);//1b-  
			break;			
#ifdef IMD_MP_TEST
		case PS_GenBinImage:	//1c-SF105 test itself,  Waiting for Synochip support custom define entry.
			cRet = SF125_Production_Test(cpBuf,psOutApp);
			break;
#elif defined(IMD_CUSTOM_UI_CMD)
		case PS_GenBinImage:	//Waiting for Synochip support custom define entry.
#ifdef IMD_NFC_M24SR_TAG_APPLIED
			cRet = SF125_NFCTag(cpBuf,psOutApp);
#endif
			break;
#endif
		case PS_ValidTempleteNum:
			cRet = CmdValidTempleteNum(cpBuf,psOutApp);//1d-УЧģ
			break;
		case PS_UserCommand:
			cRet = CmdUserCommand(cpBuf,psOutApp);//1e-GPIO  
			break;
		case PS_ReadIndexTable://2008-11-13
			cRet = CmdReadIndexTable(cpBuf,psOutApp);//1f-
			break;
		case PS_UpLumCommand:
			cRet =CmdUpLum(cpBuf,psOutApp); //ϴ 
			break;
		case PS_GetTestImage:
			cRet =CmdGetTestImage(cpBuf,psOutApp); //ɼ ͼ
			break;
		case PS_UpTestImage:			 
			cRet = CmdUpTestImage(cpBuf,psOutApp);//ϴ ͼ
			break;
		case PS_GetEnrollImage:			 
			cRet = CmdGetEnrollImage(cpBuf,psOutApp);//עʱȡͼ
			break;
		default: 
			cRet = CmdUserDefined(cpBuf,psOutApp);
			break;
	}
	return(cRet);
}

/***************************************************************************************************
** Subroutine  : CmdAutoEnroll
** Function    : Զעģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdAutoEnroll(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	static UINT16 IDtemp;
	static UINT8 GetMBNum,StoreMode,StatusTemp;
	UINT8 cAck=0,CmdTemp=0,i;
	UINT16 nScore,nwPageID;
	UINT32 CntTime;
#ifndef GENCHAR_All_AREA
	UINT16 Scoretemp;
#endif

	switch(flagCmd)
	{
		case 0://ָȷϣзء		
			CmdTemp = ONE_STOP_PARAMETER1; //״̬
			StatusTemp = ONE_STOP_PARAMETER2; //״̬
			whichCom = gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy;
        	IDtemp = psOutApp->pata[2] + (((UINT16)psOutApp->pata[1] & 0xFF) << 8);
			GetMBNum = psOutApp->pata[3];
			StoreMode = psOutApp->pata[4];
			cAck = JudgeEnrollPara(IDtemp, GetMBNum, StoreMode); //һվʽָעᣬϷԼ
			if(cAck != RT_OK)
				goto LABEXIT;
            flagCmd++;
			memset(&gsCharBuffer1,0,(FP_PER_USER * ALG_SIZE_TZ));
            break;
		case 1://ʱûзء
			StatusTemp++;	   //ǰɼָƵĴ
			psOutApp->cDoStatus = DO_OK;
			gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
			flagCmd++;
			TMR_Init(T0, 0xFFFFFFFF, TCLK_SRC_LFROSC, TMR_CNT);//24~30KHz,ȡ27KHZ4Ƶʱ6.75KHz
			TMR_ClrCnt(T0);
			TMR_Start(T0);			
			return RT_OK;
//			break;
		case 2://ȡͼзء
			CmdTemp = ONE_STOP_GetImage1;
			TMR_GetCnt(T0, &CntTime);
			if(CntTime > 0x107AC)//10s
			{
				TMR_Stop(T0);
				cAck = PS_TIME_OUT;
				flagCmd = 0;
				goto LABEXIT;
			}
			cAck = ReadFingerFromSensor_Enroll();
			if(cAck != RT_OK)
			{
				psOutApp->cDoStatus = DO_OK;
				gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
				return RT_OK;
			}
			flagCmd++;	
            break;
		case 3://зء
			CmdTemp = ONE_STOP_GenChar1;

	        if (StatusTemp==2)
	        {
	        	memset(gsCharBuffer1.cCharFile[1],0,(FP_PER_USER-1)*ALG_SIZE_TZ );
	        }
			if (StatusTemp==1)
			{        
	        	cAck = ExtractChar(gsCharBuffer1.cCharFile[StatusTemp-1],1);
			#ifdef GENCHAR_SMALL_AREA
				enrollGenCharcnt  = 0;
			#endif
			}
			else
				cAck = ExtractChar(gsCharBuffer1.cCharFile[StatusTemp-1],1);
		
		#ifdef SCHECK
			if(cAck != RT_OK)
				cAck = SecondCheck(SCHKTMS,StatusTemp);
		#endif	 
		
			if(cAck == RT_OK)
			{
				#ifdef GENCHAR_All_AREA
				cAck = PS_OK;
				#endif
		
				#ifdef GENCHAR_SMALL_AREA
				cAck = PS_OK;
				Scoretemp = SearchScore(1);//עʱֵ
				if(StatusTemp > 1 && StatusTemp < 8)
				{
					for(i = 0;i < StatusTemp - 1;i++)
					{
						if(MatchFinger(gsCharBuffer1.cCharFile[StatusTemp-1],gsCharBuffer1.cCharFile[i],Scoretemp,&nScore)== RT_OK)
						{
							MergeMbScore(1);//עʱںϷ
		//					cRet1 = MergeMbA_N((UINT8*)&gsCharBuffer1.cCharFile[i],(UINT8*)&gsCharBuffer1.cCharFile[ncBufferID-1],1);
		//					if(cRet1 == RT_OK)
		//						enrollGenCharcnt++;
							MergeMbA_N((UINT8*)&gsCharBuffer1.cCharFile[i],(UINT8*)&gsCharBuffer1.cCharFile[StatusTemp-1],1);
							enrollGenCharcnt++;
		
		//					if(enrollGenCharcnt > 2)
		//						cAck = PS_OK;
		//					else
		//						cAck = PS_LITTLE_FEATURE;					
						}
					}
				}
				#endif
			
				#ifdef GENCHAR_BIG_AREA
				cAck = PS_OK;
			    if(StatusTemp == 2)
			    {
			    	memcpy(gsCharBuffer2.cCharFile[0],gsCharBuffer1.cCharFile[1],ALG_SIZE_TZ );
			    }
				#endif
			}
			else
				cAck = PS_LITTLE_FEATURE;

			if(cAck == RT_OK)
				flagCmd++;
			else
				{
					TMR_Stop(T0);										// clear timer by Hyde
					TMR_Init(T0, 0xFFFFFFFF, TCLK_SRC_LFROSC, TMR_CNT);	// clear timer by Hyde
					TMR_ClrCnt(T0);										// clear timer by Hyde
					TMR_Start(T0);										// clear timer by Hyde
					flagCmd = 2;
				}
            break;			
		case 4://жָ뿪뿪֮ǰûзأ뿪֮зء
			CmdTemp = ONE_STOP_FigLeave1;
			if(StatusTemp < GetMBNum)		//һβټָ뿪
			{
				TMR_GetCnt(T0, &CntTime);
				if(CntTime > 0x107AC)
				{
					TMR_Stop(T0);
					cAck = PS_TIME_OUT;
					flagCmd = 0;
					goto LABEXIT;
				}
				cAck = ReadFingerFromSensor();
				if(cAck == RT_OK)
				{
					psOutApp->cDoStatus = DO_OK;
					gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
					return RT_OK;
				}
				else
				{
					TMR_Stop(T0);
					cAck = RT_OK;			
					flagCmd = 1;
				}			
			}
			else
			{
				TMR_Stop(T0);
				flagCmd++;
				psOutApp->cDoStatus = DO_OK;
				gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
				return RT_OK;
			}	
			break;
		case 5://ϳģ壬зء
			cAck = PS_OK;
			CmdTemp = ONE_STOP_RegModel1;
			StatusTemp = ONE_STOP_RegModel2;

			#ifdef GENCHAR_BIG_AREA
			Scoretemp = SearchScore(1);//עʱֵ
			if(MatchFinger(gsCharBuffer1.cCharFile[0],gsCharBuffer2.cCharFile[0],Scoretemp,&nScore)== RT_OK)
				cAck = PS_OK;
			else
			{
				cAck = PS_MERGE_ERR;
				flagCmd = 0;
				goto LABEXIT;
			}
			#endif
		
			MergeMbScore(1);//עʱںϷ	
			if (MergeFingerN((UINT8*)&gsCharBuffer1, FP_PER_USER)==RT_OK)
			{
				cAck = PS_OK;
				memset(gsCharBuffer1.cCharFile[Enroll_MB_USER],0,(FP_PER_USER-Enroll_MB_USER)*ALG_SIZE_TZ);
				memcpy(gsCharBuffer2.cCharFile[0],gsCharBuffer1.cCharFile[0],(FP_PER_USER*ALG_SIZE_TZ));
				flagCmd++;
			}
			else
			{
				cAck = PS_MERGE_ERR;
				flagCmd = 0;
			}	
            break;
		case 6://зء
			CmdTemp = ONE_STOP_Search1;
			StatusTemp = ONE_STOP_Search2;
			if(((StoreMode & 0x02) != 0x00) && ((StoreMode & 0x01) == 0x00))//λ㣨⣩ڰλΪ()
			{
				for(i=0;i<GetMBNum;i++)
				{
					cAck = RunSearch(gsCharBuffer1.cCharFile[i], 0, FP_MB_MAX, &nwPageID, &nScore);
					if(cAck == RT_OK)
				    {
						cAck = PS_FP_DUPLICATION;
						flagCmd = 0;
						goto LABEXIT;	
				    }
				}
			}
			cAck = RT_OK;
            flagCmd++;
            break;
		case 7://洢зء
			CmdTemp = ONE_STOP_StoreChar1;
			StatusTemp = ONE_STOP_StoreChar2;
			flagCmd = 0;
			cAck = SaveUserFp(&gsCharBuffer1, IDtemp);
            break;
	}

LABEXIT:
    psOutApp->cDatStus = COMM_INS;
    psOutApp->pcDat = gsCommHandle.pImgBuf;
    psOutApp->dwDatLen = 0;
    
    psOutApp->cACK = cAck;  
	psOutApp->pata[0] = cAck;
	psOutApp->pata[1] = CmdTemp;
	psOutApp->pata[2] = StatusTemp;
	psOutApp->cpataLen = 3;
	psOutApp->cDoStatus = DO_WAIT;
    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : CmdAutoIdentify
** Function    : Զָ֤
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdAutoIdentify(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{

	static UINT16 IDtemp,OldMatchScore;//,IdentifyPara;
	static UINT8 SecurityLV;
	UINT8 cAck,cAcktp,CmdTemp=0,i;
	UINT16 nScore = 0,nwPageID = 0xFFFF,UserId = 0xFFFF,Scoretemp = 0;
	UINT32 CntTime;

	switch(flagCmd)
	{
		case 0://ָȷϣзء				
			whichCom = gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy;
			CmdTemp = ONE_STOP_PARAMETER1; //״̬
			SecurityLV = psOutApp->pata[1];
			IDtemp = psOutApp->pata[3] + (((UINT16)psOutApp->pata[2] & 0xFF) << 8);

			OldMatchScore = gwMatchScore;
			cAck = JudgeIdentifyPara(SecurityLV, IDtemp);//һվʽָ֤ϷԼ
			if(cAck != RT_OK)
				goto LABEXIT;
            flagCmd++;
			memset(&gsCharBuffer1,0,(FP_PER_USER * ALG_SIZE_TZ));
            break;
		case 1://ʱûзء
			psOutApp->cDoStatus = DO_OK;
			gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
			flagCmd++;
			TMR_Init(T0, 0xFFFFFFFF, TCLK_SRC_LFROSC, TMR_CNT);
			TMR_ClrCnt(T0);
			TMR_Start(T0);			
			return RT_OK;
//			break;
		case 2://ȡͼзء
			CmdTemp = ONE_STOP_GetImage1;
			TMR_GetCnt(T0, &CntTime);
			if(CntTime > 0x107AC)
			{
				TMR_Stop(T0);
				cAck = PS_TIME_OUT;
				flagCmd = 0;
				gwMatchScore = OldMatchScore;
				goto LABEXIT;
			}
			cAck = ReadFingerFromSensor();
			if(cAck != RT_OK)
			{
				psOutApp->cDoStatus = DO_OK;
				gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
				return RT_OK;
			}
			flagCmd++;		
            break;
		case 3://зأɹ޷ء
			CmdTemp = ONE_STOP_Search1;
			cAck = ExtractChar(gsCharBuffer1.cCharFile[0],0);
		
		#ifdef SCHECK
			if(cAck != RT_OK)
				cAck = SecondCheck(SCHKTMS,1);
		#endif	 
		
			if(cAck != RT_OK)
			{
				flagCmd = 0;
				TMR_Stop(T0);
				cAck = PS_NOT_SEARCHED;
				gwMatchScore = OldMatchScore;	
				goto LABEXIT;
			}

			TMR_Stop(T0);
			flagCmd++;
			psOutApp->cDoStatus = DO_OK;
			gsCommHandle.stComInterFace.stPkgRec.cInterfaceTy = NO_COMM_WORK;
			return RT_OK;	
//            break;
		case 4://зء
			CmdTemp = ONE_STOP_Search1;
			if(IDtemp == 0xFFFF)//1:N
			{
				cAck = RunSearch(gsCharBuffer1.cCharFile[0], 0, FP_MB_MAX, &nwPageID, &nScore);
				if (cAck==RT_OK)
					UserId = FPMBIndexToUserID(nwPageID);
			}
			else //1:1
			{
				Scoretemp = SearchScore(0);//ʱֵ
				cAcktp = GetUserFp(&gsCharBuffer2,IDtemp);
				cAck = RT_FAIL;
				if(cAcktp == RT_OK)
				{
					UserId=IDtemp;
					for(i=0;i<FP_PER_USER;i++)
					{
						if(MatchFinger(gsCharBuffer1.cCharFile[0],gsCharBuffer2.cCharFile[i],Scoretemp,&nScore)== RT_OK)
						{
							cAck = PS_OK;
							break;
						}
					}
				}
			}
			
			if (cAck==RT_OK)//洢ں²ɼָ
			{
			    if(RT_FAIL == AddUserFpMb(gsCharBuffer1.cCharFile[0],UserId))	
			    	UserMbMergeFeature(gsCharBuffer1.cCharFile[0],UserId,nwPageID,0);
			}
			else
			{ 
				UserId = 0xFFFF;
				nScore = 0;
			}

            flagCmd = 0;
			gwMatchScore = OldMatchScore;
            break;
	}
								  
LABEXIT:
    psOutApp->cDatStus = COMM_INS;
    psOutApp->pcDat = gsCommHandle.pImgBuf;
    psOutApp->dwDatLen = 0;
    
    psOutApp->cACK = cAck;  
	psOutApp->pata[0] = cAck;
	psOutApp->pata[1] = CmdTemp;
	psOutApp->pata[2] = (UserId >> 8) & 0xFF;
	psOutApp->pata[3] = UserId & 0xFF;
	psOutApp->pata[4] = (nScore >> 8) & 0xFF;
	psOutApp->pata[5] = nScore & 0xFF;;
	psOutApp->cpataLen = 6;
	psOutApp->cDoStatus = DO_WAIT;
    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : CmdSleep
** Function    : ˯ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdSleep(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;	

	cAck = PS_OK;
	
    psOutApp->cDatStus = COMM_INS;
    psOutApp->pcDat = gsCommHandle.pImgBuf;
    psOutApp->dwDatLen = 0;
    
    psOutApp->cACK = cAck;  
	psOutApp->pata[0] = cAck;
	psOutApp->cpataLen = 1;
	psOutApp->cDoStatus = DO_WAIT;
    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : CmdGetGhipSN
** Function    : Get chip series number 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGetGhipSN(UINT8 *cpRecBuf, PKG_OUT_APP *psOutApp)
{
	UINT8 cAck=0;
	
	UINT8 nSN[32];
	UINT16 nLen;
	EFC_ReadChipSN (nSN, &nLen);
	  
    psOutApp->cDatStus = COMM_INS;
    psOutApp->pcDat = gsCommHandle.pImgBuf;
    psOutApp->dwDatLen = 0;
    
    psOutApp->cACK = cAck;  
	psOutApp->pata[0] = cAck;
	memcpy(&psOutApp->pata[1], nSN, nLen);
	psOutApp->cpataLen = nLen+1;
	psOutApp->cDoStatus = DO_WAIT;
	
    return RT_OK;
}
/***************************************************************************************************
** Subroutine  : CmdUpTestImage
** Function    : ϴͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdUpTestImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	
    cAck = PS_OK;  
    psOutApp->cDatStus=COMM_IMG_SEND;
    psOutApp->cACK=cAck;  
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDataOffset=0;
    psOutApp->dwDatLen=232*312;
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;
}

/***************************************************************************************************
** Subroutine  : CmdGetTestImage
** Function    : ɼͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGetTestImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;

	ReadFingerFromSensor_Test();	
	cAck = PS_OK;
	
    psOutApp->cDatStus=COMM_INS;
    psOutApp->cACK=cAck;  
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;
    
}

/***************************************************************************************************
** Subroutine  : CmdUpLum
** Function    : UP LUM  to MCU 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdUpLum(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT32 cInform;
	UINT16 data1;
	UINT16 data2;
	UINT16 temp;
	UINT16 *p;
	UINT16 i;
	UINT16 j;

	cInform=0;
	p=(UINT16 *)gsCommHandle.pImgBuf;//0x9000D400;
	for(i=0;i<288;i++)
	{
		for(j=0;j<128;j++)
		{
			p++;
			data1=((*p)&0xff00)>>8;
			data2= (*p)&0x00ff;
			cInform+=(UINT32)data1+(UINT32)data2;
		}
	}
	
	cInform=cInform/256/288;
	temp=(UINT16)cInform;
	
    psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=PS_OK;  
    psOutApp->pata[0]=PS_OK;
    psOutApp->pata[1]=(UINT8)temp;
    psOutApp->cpataLen=2;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;
    
}
	
/***************************************************************************************************
** Subroutine  : CmdReadIndexTable
** Function    : read mb index table
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdReadIndexTable(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,ncPageID;
	UINT8 i,j,nVal;
	UINT8 *ncpContent;
	
	
	ncPageID = cpRecBuf[10];
	
	if(ncPageID >= MAX_INDEX_PAGE)
	{
		cAck = PS_ADDRESS_OVER;                //pageid error
		goto LABEXIT;
	}
	
	ncpContent=psOutApp->pata;
	for(i=0;i<32;i++)
	{
		nVal=0;
		for(j=0;j<8;j++)
		{
			if(checkVaildUserId(ncPageID*256+i*8+j)==RT_OK)
				nVal+=(1<<j);
		}
		ncpContent[i+1]=nVal;
	}
	cAck = PS_OK;
	
LABEXIT:

	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=0x0021;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}
	
/***************************************************************************************************
** Subroutine  : CmdEnroll
** Function    : עһöָ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdEnroll(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
#ifdef AUTO_CMD
	UINT8 cAck,cRet;
	UINT16 wMBID;

	cRet =ReadFingerFromSensor();
	
	if (cRet== RT_OK)
		cAck = PS_OK;
	else if(cRet == NO_DETECT_FINGER)
		cAck = PS_NO_FINGER;
	else
		cAck = PS_GET_IMG_ERR;
	
	if(cAck!=PS_OK)
		goto LABEXIT;
		
	memset(&gsCharBuffer1,0,sizeof(gsCharBuffer1));
	
	if(ExtractChar(gsCharBuffer1.cCharFile[0],1) == RT_FAIL)     //ȡָͼ
	{
		cAck = PS_ENROLL_ERR;
		goto LABEXIT;
	}	
	
	cAck = PS_LIB_FULL_ERR;
	if (GetFreeUesrId(&wMBID)==RT_OK)
	{
		cRet =SaveUserFp(&gsCharBuffer1,wMBID);
		if (cRet==RT_OK)
		{
    		cAck = PS_OK;	
		}
	}
	
LABEXIT:
    
    psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
    psOutApp->pata[0]=cAck;
	psOutApp->pata[1] = (wMBID >> 8) & 0xff;
	psOutApp->pata[2] = wMBID & 0xff;
    psOutApp->cpataLen=3;
#endif
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}
	
/***************************************************************************************************
** Subroutine  : CmdGetImage
** Function    : ɼͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGetImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRetCode;
	UINT8 cAck;
       
	
	cRetCode =ReadFingerFromSensor();
	if (cRetCode== RT_OK)
	{
		cAck = PS_OK;
	}
	else 
	{
		cAck = PS_NO_FINGER;
	}
      

		
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;  
}
	
/***************************************************************************************************
** Subroutine  : CmdGetEnrollImage
** Function    : ɼͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGetEnrollImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRetCode;
	UINT8 cAck;
	
	
	cRetCode =ReadFingerFromSensor_Enroll();
	if (cRetCode== RT_OK)
	{
		cAck = PS_OK;
	}
	else if(cRetCode == NO_DETECT_FINGER)
	{
		cAck = PS_NO_FINGER;
	}
	else
		cAck = PS_GET_IMG_ERR;
		
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}
	
/***************************************************************************************************
** Subroutine  : CmdGenChar
** Function    : ȡ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGenChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRet,cAck;
	UINT8 ncBufferID;
//	UINT8 ncAcknet = 1;	



#ifdef GENCHAR_SMALL_AREA
	UINT8 i;
	UINT16 nScore,Scoretemp;
	Scoretemp = SearchScore(1);//עʱֵ
#endif	
	ncBufferID = cpRecBuf[10];			

	if (ncBufferID>FP_PER_USER||ncBufferID<1)
	{
        cAck = RT_FAIL;
		goto LABEXIT;
	}     
    else
    {
        if (ncBufferID==2)
        {
        	memset(gsCharBuffer1.cCharFile[1],0,(FP_PER_USER-1)*ALG_SIZE_TZ );
        }
		if (ncBufferID==1)
		{        
        	cRet = ExtractChar(gsCharBuffer1.cCharFile[ncBufferID-1],0);
		#ifdef GENCHAR_SMALL_AREA
			enrollGenCharcnt  = 0;
		#endif 
		}
		else
			cRet = ExtractChar(gsCharBuffer1.cCharFile[ncBufferID-1],1);
    }	

#ifdef SCHECK
	if(cRet != RT_OK)
		cRet = SecondCheck(SCHKTMS, ncBufferID);
#endif	 
	
/*ȡָͼ*/
	if(cRet == RT_OK)
	{
		#ifdef GENCHAR_All_AREA
		cAck = PS_OK;
		#endif

		#ifdef GENCHAR_SMALL_AREA
		cAck = PS_OK;
		if(ncBufferID > 1 && ncBufferID < 8)
		{
			for(i = 0;i < ncBufferID - 1;i++)
			{
				if(MatchFinger(gsCharBuffer1.cCharFile[ncBufferID-1],gsCharBuffer1.cCharFile[i],Scoretemp,&nScore) == RT_OK)
				{
					MergeMbScore(1);//עʱںϷ
//					cRet1 = MergeMbA_N((UINT8*)&gsCharBuffer1.cCharFile[i],(UINT8*)&gsCharBuffer1.cCharFile[ncBufferID-1],1);
//					if(cRet1 == RT_OK)
//						enrollGenCharcnt++;
					MergeMbA_N((UINT8*)&gsCharBuffer1.cCharFile[i],(UINT8*)&gsCharBuffer1.cCharFile[ncBufferID-1],1);
					enrollGenCharcnt++;

//					if(enrollGenCharcnt > 2)
//						cAck = PS_OK;
//					else
//						cAck = PS_LITTLE_FEATURE;					
				}
			}
		}
		#endif
	
		#ifdef GENCHAR_BIG_AREA
		cAck = PS_OK;
	    if(ncBufferID == 2)
	    {
	    	memcpy(gsCharBuffer2.cCharFile[0],gsCharBuffer1.cCharFile[1],ALG_SIZE_TZ );
	    }
		#endif
	}
	else if(cRet == RT_FAIL)
	{
		cAck = PS_LITTLE_FEATURE;// cAck = PS_FP_DISORDER;   
	}			
	else
		cAck = PS_LITTLE_FEATURE;
              

LABEXIT:				
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
    psOutApp->pata[0]=cAck;
    psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

UINT8 SecondCheck(UINT8 chktms,UINT8 ncBufferID)
{
    UINT8 cRetCode;
    UINT8 i;
    UINT8 cRet = RT_FAIL;
	   
	for(i=0;i<chktms;i++)
	{
        cRetCode =ReadFingerFromSensor();
        
        if(cRetCode == RT_OK)
	    {  
			if (ncBufferID==1)   
	         	cRet = ExtractChar(gsCharBuffer1.cCharFile[ncBufferID-1],0);
			else
				cRet = ExtractChar(gsCharBuffer1.cCharFile[ncBufferID-1],1);

            if (cRet == RT_OK)
    		  break;
    	}
//        else
//        {
//        	cRet=RT_FAIL;
//        	break;
//        }            
	}
	
    return(cRet);			
}
	
/***************************************************************************************************
** Subroutine  : CmdMatch
** Function    : ȶ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdMatch(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,i;
	UINT16 nScore,Scoretemp;

	Scoretemp = SearchScore(0);//ʱֵ	
/*ȶöָͼ*/
	for(i=0;i<FP_PER_USER;i++)
	{
		if(MatchFinger(gsCharBuffer1.cCharFile[0],gsCharBuffer2.cCharFile[i],Scoretemp,&nScore)== RT_OK)
		{
			cAck = PS_OK;
			break;
		}
		else
			cAck = PS_NOT_MATCH;
	}
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck; 
	psOutApp->pata[1] = nScore/256;
	psOutApp->pata[2] = nScore%256;
	psOutApp->cpataLen=3;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}
/***************************************************************************************************
** Subroutine  : CmdSearch
** Function    :  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/	
//extern INT32 gOverAreaPercent;//غռİٷֱ
UINT8 CmdSearch(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	UINT8 ncBufferID;
	UINT16 nwStartPage,nwPageNum;
	UINT8 *pChar;
	UINT16 nwPageID,UserId;
	UINT16 nScore;
          

	MergeMbScore(0);//ʱںϷ	
	ncBufferID = cpRecBuf[10];
	nwStartPage = cpRecBuf[11] & 0xff ;
	nwStartPage = (nwStartPage << 8) | (cpRecBuf[12] & 0xff);
	nwPageNum = cpRecBuf[13] & 0xff;
	nwPageNum = (nwPageNum << 8) | (cpRecBuf[14] & 0xff);


	cAck = PS_NOT_SEARCHED;
	nwPageID = 0;
	nwPageNum = UserIDToFPMBIndex(nwPageNum);

    pChar=gsCharBuffer1.cCharFile[ncBufferID-1];    
	cAck=RunSearch(pChar,nwStartPage,nwPageNum,&nwPageID,&nScore);
    UserId=FPMBIndexToUserID(nwPageID);
    if (cAck==RT_OK)
    {
		if(nScore > 60)
		{
			if(RT_OK == UserMbMergeFeature(pChar,UserId,nwPageID,0))
			{
//				if(gOverAreaPercent < 60)
					AddUserFpMb(pChar,UserId);				
			}								
		}		
	}
 

	psOutApp->cDatStus	= COMM_INS;
    psOutApp->pcDat		= gsCommHandle.pImgBuf;
    psOutApp->dwDatLen	= 0;
    
    psOutApp->cACK 		= cAck;  
	psOutApp->pata[0]	= cAck;
	psOutApp->pata[1] 	= UserId/256;
	psOutApp->pata[2] 	= UserId%256;
	psOutApp->pata[3] 	= nScore/256;
	psOutApp->pata[4] 	= nScore%256;
	psOutApp->cpataLen	= 5;
	psOutApp->cDoStatus	= DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdRegModel
** Function    : ģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdRegModel(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;

#ifdef GENCHAR_BIG_AREA
	UINT16 Scoretemp,nScore;
	Scoretemp = SearchScore(1);//עʱֵ
	if(MatchFinger(gsCharBuffer1.cCharFile[0],gsCharBuffer2.cCharFile[0],Scoretemp,&nScore)== RT_OK)
		cAck = PS_OK;
	else
	{
		cAck = PS_MERGE_ERR;
		goto LABEXIT;
	}
#endif

	MergeMbScore(1);//עʱںϷ	
	if (MergeFingerN((UINT8*)&gsCharBuffer1, FP_PER_USER)==RT_OK)
	{
		cAck = PS_OK;
		memset(gsCharBuffer1.cCharFile[Enroll_MB_USER],0,(FP_PER_USER-Enroll_MB_USER)*ALG_SIZE_TZ);
		memcpy(gsCharBuffer2.cCharFile[0],gsCharBuffer1.cCharFile[0],(FP_PER_USER*ALG_SIZE_TZ));
	}
	else
		cAck = PS_MERGE_ERR;

//	#ifndef GENCHAR_BIG_AREA	
//	if(MatchModelDifferentCnt(2) != RT_OK)
//		cAck = RT_FAIL;
//	#endif

#ifdef GENCHAR_BIG_AREA
LABEXIT:
#endif	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdStoreChar
** Function    : 洢ģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdStoreChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRet,cAck;
	StruMBFile *ncpAddr;
	UINT16 nwPageNum;
	
	nwPageNum = cpRecBuf[11] & 0xff;
	nwPageNum = (nwPageNum << 8) | (cpRecBuf[12] & 0xff);
	
	
	//nwPageNum = cpRecBuf[11] * 256 + cpRecBuf[12];
	
	if(cpRecBuf[10] == 1)
		ncpAddr=&gsCharBuffer1;
	else
		ncpAddr=&gsCharBuffer2;
	
	cRet =SaveUserFp(ncpAddr, nwPageNum);
	
	if(cRet == RT_OK)
	{
		cAck = PS_OK;
	}
	else
		cAck = cRet;
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdLoadChar
** Function    : ģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdLoadChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,cRet,cBufferID;
	UINT16 wPageID;
	StruMBFile *ncpAddr;
	
	cBufferID = cpRecBuf[10];
	BW(cpRecBuf[11],cpRecBuf[12],wPageID);

	if(cBufferID == 1)
		ncpAddr=&gsCharBuffer1;
	else
		ncpAddr=&gsCharBuffer2;	
	
	cRet = GetUserFp(ncpAddr,wPageID);
	if(cRet == RT_OK)
	{
		cAck = PS_OK;
	}
	else
		cAck = cRet;
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdUpChar
** Function    : ϴģ
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdUpChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,cBufferID;
	
	cBufferID = cpRecBuf[10];
	
	if(cBufferID == 0x01)
		psOutApp->pcDat=(UINT8*)&gsCharBuffer1;//.cCharFile[0];//gsCharBuffer1;//memcpy(cpAddr,&gsCharBuffer1,512);
	else
		psOutApp->pcDat=(UINT8*)&gsCharBuffer2;//memcpy(cpAddr,&gsCharBuffer2,512);
	
	cAck = PS_OK;
	
	psOutApp->cDatStus=COMM_DATA_SEND;
    psOutApp->dwDatLen=USER_PF_SPEC;
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdDownChar
** Function    : ģ
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdDownChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	
    if(cpRecBuf[10] == 0x01)
		psOutApp->pcDat=(UINT8 *)&gsCharBuffer1;
	else
		psOutApp->pcDat=(UINT8 *)&gsCharBuffer2;

	memset(psOutApp->pcDat,0,FP_PER_USER*ALG_SIZE_TZ );		
    cAck = PS_OK;
    psOutApp->cDatStus=COMM_DATA_REC;
    psOutApp->dwDatLen=USER_PF_SPEC;
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdUpImage
** Function    : ϴͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdUpImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	

    cAck = PS_OK;    
	psOutApp->cDatStus=COMM_IMG_SEND;
 #if IMAGE_GENCHAR_FLAG == 1
	psOutApp->pcDat=gsCommHandle.pImgBuf + 0x800;
#else
	psOutApp->pcDat=gsCommHandle.pImgBuf;
#endif

#if(CHANGE_IMG_SIZE == IMG_SIZE1)
    psOutApp->dwDatLen=256*360;
#else
    psOutApp->dwDatLen=256*288;
#endif
    psOutApp->dwDataOffset=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdDownImage
** Function    : ͼ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdDownImage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;

    cAck = PS_OK;
    psOutApp->cDatStus=COMM_DATA_REC;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=256*288;
    psOutApp->dwDataOffset=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdDeleteChar
** Function    : ɾģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdDeleteChar(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRet,cAck;
	UINT16 nwPageNum,nwDelNum;

	nwPageNum = cpRecBuf[10] * 256 + cpRecBuf[11];
	nwDelNum = cpRecBuf[12] * 256 + cpRecBuf[13];

	cRet=DeteleUser(nwPageNum,nwDelNum);
	
	if(cRet == RT_OK)
		cAck = PS_OK;
	else
		cAck = PS_DEL_TEMP_ERR;
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdEmpty
** Function    : ɾģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdEmpty(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRet,cAck;
	
	cRet = DeteleUserAll();
	if(cRet == RT_OK)
		cAck = PS_OK;
	else
		cAck = PS_CLEAR_TEMP_ERR;
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdWriteReg
** Function    : ò 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/	
UINT8 CmdWriteReg(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,cBaudFlg;
	UINT8 cReqSeq,cContent;
	
#ifdef USE_UART	
	cBaudFlg = 0;
#endif
	
	cReqSeq = cpRecBuf[10];
	cContent = cpRecBuf[11];
	cBaudFlg = 0;
	
	if(cReqSeq == 0x04)
	{
		if(cContent>200 || cContent==0)
		{
			cAck=PS_ADDRESS_OVER;
			goto LABEXIT;
		}
		
		gParaTab.CFG_BaudRate = cContent;
		
#ifdef USE_UART
		cBaudFlg = 1;
#endif
	}
	else if(cReqSeq == 0x05)
	{
		if(cContent==0 || cContent>5)
			cContent=3;
		
		gParaTab.SecurLevel = cContent;
/*ȶֵ*/
		switch(cContent)
		{
			case 1: gwMatchScore=22;break;
			case 2: gwMatchScore=36;break;
			case 3: gwMatchScore=50;break;
			case 4: gwMatchScore=60;break;
			case 5: gwMatchScore=70;break;
			default: gwMatchScore=50;break;
		}
	}
	else if(cReqSeq == 0x06)
	{
		if(cContent>3)
			cContent=3;
		
		gParaTab.CFG_PktSize = cContent;
		
		if(gParaTab.CFG_PktSize == 0)
			gsCommHandle.dwPktSize = 32;
		else if(gParaTab.CFG_PktSize == 1)
			gsCommHandle.dwPktSize = 64;
		else if(gParaTab.CFG_PktSize == 2)
			gsCommHandle.dwPktSize = 128;
		else if(gParaTab.CFG_PktSize == 3)
			gsCommHandle.dwPktSize = 256;
		else
			gsCommHandle.dwPktSize = 128;
	}
	else
	{
		cAck = PS_INVALID_REG;
		goto LABEXIT;
	}
	
	WriteParaTab();
	
	cAck = PS_OK;
LABEXIT:
    gsCommHandle.cInitItrfce=1;
    psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	
#ifdef USE_UART
	if(1==cBaudFlg)
	{
		psOutApp->cDoStatus=DO_OK;
		DoAppOut(psOutApp);
		_delay_ms(100);
		UART_InitBaudrate(gParaTab.CFG_BaudRate);
	}
	else
#endif
	{
		psOutApp->cDoStatus=DO_WAIT;
	}
    return RT_OK;   
}


/***************************************************************************************************
** Subroutine  : CmdReadSysPara
** Function    :  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdReadSysPara(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cTmp,cAck;
	UINT8 *ncpAddr;
	UINT16 i;
	
	ncpAddr = psOutApp->pata; 
	ncpAddr++;
	ReadSysPapaImfo(ncpAddr);   //ȡϢ
	for(i=0;i<256;i++)
	{
		cTmp=ncpAddr[i*2+1];
		ncpAddr[i*2+1]=ncpAddr[i*2];
		ncpAddr[i*2]=cTmp;
	}
	
	cAck = PS_OK;
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=0x0011;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdIdentify
** Function    : ģ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdIdentify(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
#ifdef AUTO_CMD
	UINT8 cAck,cRet;
	UINT16 nwPageID=0,UserId=0;
	UINT16 nScore;
	
	cAck = PS_NOT_SEARCHED;
	cRet =ReadFingerFromSensor();
	
	if (cRet== RT_OK)
		cAck = PS_OK;
	else if(cRet == NO_DETECT_FINGER)
		cAck = PS_NO_FINGER;
	else
		cAck = PS_GET_IMG_ERR;
	
	if(cAck!=PS_OK)
		goto LABEXIT;
/*ȡָ*/
	if( ExtractChar(gsCharBuffer1.cCharFile[0],1) == RT_FAIL)
	{
		cAck = PS_LITTLE_FEATURE;
		goto LABEXIT;
	}
/*ָ*/
	cAck=RunSearch(gsCharBuffer1.cCharFile[0],0,FP_MB_MAX,&nwPageID,&nScore);
    UserId=FPMBIndexToUserID(nwPageID);
    if (cAck==RT_OK)
    {
        if(RT_FAIL == AddUserFpMb(gsCharBuffer1.cCharFile[0],UserId))	
        	UserMbMergeFeature(gsCharBuffer1.cCharFile[0],UserId,nwPageID,1);
    }


	
	LABEXIT:
        
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck; 
    psOutApp->pata[0] = cAck;
	psOutApp->pata[1] = (UserId >> 8) & 0xff;
	psOutApp->pata[2]  =  UserId & 0xff;
	psOutApp->pata[3] = (nScore >> 8) & 0xff;
	psOutApp->pata[4] = nScore & 0xff;
	psOutApp->cpataLen=5; 
#endif
    psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdSetPwd
** Function    :  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/ 
UINT8 CmdSetPwd(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	
	//ʼָ
	gParaTab.PassWord[0] = ((cpRecBuf[10] &0xff ) << 8) | (cpRecBuf[11] & 0xff);
	gParaTab.PassWord[1] = ((cpRecBuf[12] & 0xff) << 8) | (cpRecBuf[13]  & 0xff);
	gsCommHandle.dwCommPsd=gParaTab.PassWord[0];
    gsCommHandle.dwCommPsd=((gsCommHandle.dwCommPsd & 0xffff) << 16) | (gParaTab.PassWord[1] & 0xffff);
        
	WriteParaTab();
	
	cAck = PS_OK;
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdVfyPwd
** Function    : У 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdVfyPwd(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	UINT32 nlPassWord;

	nlPassWord = cpRecBuf[10] & 0xff;
	nlPassWord = nlPassWord << 8 | cpRecBuf[11] ;
	nlPassWord = nlPassWord << 8 | cpRecBuf[12];
	nlPassWord = nlPassWord << 8 | cpRecBuf[13];
	
	if(nlPassWord != gsCommHandle.dwCommPsd)   //У
		cAck = PS_INVALID_PASSWORD;
	else
	{
        gsCommHandle.cPwdVfyFg=1; 
		cAck = PS_OK;
	}
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdGetRandomCode
** Function    : ȡ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdGetRandomCode(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT32 lRandVal;
	UINT8 cAck;
	
/*ȡ64λ */
//	RngRegs.POWERDOWN = 1;					//ʹģԴ
	SCM_AnModPowerEnable(AN_TRNG_RING);		//ʹ񵴻
	SCM_EnableModClk(ID_TRNG);				//ʹģʱ
	SCM_ReleaseModRst(ID_TRNG);				//ģ鸴λͷţ
	cAck = Trng_Init(0);
	if(cAck != RT_OK)
	{
		cAck = PS_TRNG_ERR;
		goto LABEXIT;
	}
	cAck = Trng_GenRandom ((UINT8 *)(&lRandVal), 4);	
	if(cAck != RT_OK)
	{
		cAck = PS_TRNG_ERR;
		goto LABEXIT;
	}
	
LABEXIT:
//	RngRegs.POWERDOWN = 0;					//رģԴ
	SCM_AnModPowerDisable(AN_TRNG_RING);	//ر񵴻ʹ
	SCM_DisableModClk(ID_TRNG);				//رģʱ
	SCM_KeepModRst(ID_TRNG);				//ģ鸴λ   
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0] = cAck;        //ȷ
	psOutApp->pata[1] = (lRandVal >> 24) & 0xff;
	psOutApp->pata[2] = (lRandVal >> 16) & 0xff;
	psOutApp->pata[3] = (lRandVal >> 8) & 0xff;
	psOutApp->pata[4] = lRandVal &0xff;
	psOutApp->cpataLen=5;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}
/***************************************************************************************************
** Subroutine  : CmdSetChipAddr
** Function    : õַ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdSetChipAddr(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	
	gParaTab.DeviceAddr[0] = ((cpRecBuf[10] &0xff ) << 8) | (cpRecBuf[11] & 0xff);
	gParaTab.DeviceAddr[1] = ((cpRecBuf[12] & 0xff) << 8) | (cpRecBuf[13]  & 0xff);
	
	WriteParaTab();
	
	cAck = PS_OK;
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdReadINFpage
** Function    : ȡϢ 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdReadINFpage(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cTmp,cAck;
	UINT8 *ncpAddr;
	UINT16 i;
	
	cAck = PS_OK;
	ncpAddr = gsCommHandle.pImgBuf;
	
	ReadSysPapaImfo(ncpAddr);   //ȡϢ
	for(i=0;i<256;i++)
	{
		cTmp=ncpAddr[i*2+1];
		ncpAddr[i*2+1]=ncpAddr[i*2];
		ncpAddr[i*2]=cTmp;
	}
	
	psOutApp->cDatStus=COMM_DATA_SEND;
    psOutApp->pcDat=ncpAddr;
    psOutApp->dwDatLen=512;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdPortControl
** Function    : ͨѶ˿ڿ/ر 
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdPortControl(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	
	cAck=PS_OK;	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdWriteNotepad
** Function    : д±  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/
UINT8 CmdWriteNotepad(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,ncPageID,cRet;
	UINT8 ncpContent[32];
	UINT16 i;
	
	ncPageID = cpRecBuf[10];
	if(ncPageID > NOTEPAD_MAX_PAGEID)
	{
		cAck = PS_ADDRESS_OVER;                //pageid error
		goto LABEXIT;
	}
	
	for(i = 0;  i < 32; i++)
		ncpContent[i] = cpRecBuf[11+i];
/*дϢҳ*/
	cRet = WriteNoteDataPage(ncpContent,ncPageID*32,32);
	if(cRet == RT_OK)
		cAck = PS_OK;
	else
		cAck = PS_FLASH_ERR;
	
	LABEXIT:
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdReadNotepad
** Function    : ±  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/ 
UINT8 CmdReadNotepad(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck,ncPageID;
/*	test use
    UINT8 i=0,Reg0x01Gain = 0;
    UINT8 Reg0x02Gain = 0;
*/
	ncPageID = cpRecBuf[10];
	
	if(ncPageID > NOTEPAD_MAX_PAGEID)
	{
		cAck = PS_ADDRESS_OVER;                //pageid error
		goto LABEXIT;
	}
	
/*|??*/
	ReadNoteDataPage(&psOutApp->pata[1],ncPageID*32,32);	
	cAck = PS_OK;
/*	test use	
    for (i=0;i<15,i++)
	{
	SensorReadReg(i, &Reg0x01Gain);
    psOutApp->pata[i+1] = Reg0x01Gain;
    }
	//SensorReadReg(0x02, &Reg0x02Gain);
    //psOutApp->pata[2] = Reg0x02Gain;
 */   
    
    LABEXIT:
    psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=0x0021;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdBurnCode
** Function    :   
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/  
UINT8 CmdBurnCode(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cAck;
	 
	cAck=PS_OK;	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->cpataLen=1;
	psOutApp->cDoStatus=DO_WAIT;
	gParaTab.ParaTabFlg=0xffff;//Clear para
	WriteParaTab();	

//	RngRegs.POWERDOWN = 1;					//ʹģԴ
	SCM_AnModPowerEnable(AN_TRNG_RING);		//ʹ񵴻
	SCM_EnableModClk(ID_TRNG);				//ʹģʱ
	SCM_ReleaseModRst(ID_TRNG);				//ģ鸴λͷţ
	   
	if (psOutApp->cDoStatus == DO_WAIT)
	{
        DoAppOut(psOutApp);
	} 
    _delay_ms(3000);
	//־
	ClearRunFlag();

	//λ	
	RunProgram(0);

	return RT_OK; 	
}

/***************************************************************************************************
** Subroutine  : CmdHighSpeedSearch
** Function    :   
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/ 
UINT8 CmdHighSpeedSearch(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT8 cRet;
	
	cRet = CmdSearch(cpRecBuf,psOutApp);
	
	return cRet;
}

#ifdef IMD_MP_TEST
/***************************************************************************************************
** Subroutine  : SF125_Production_Test
** Function    : SF125 MP Test Function  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Format      : 
** Description : 
*
*           The format of package:
*           Byte       |*** 2 ***|****** 4 ******|** 1 **|** 2 **|*** 1 ***|*** 1 ***|** 2 **|
*           Reveiced:  -----------------------------------------------------------------------
*                      |  Header |  Chip Address |  Flag |  Len  |  Action |   Type  |  Sum  |
*                      -----------------------------------------------------------------------
*           Responsed: -----------------------------------------------------------------------
*                      |  Header |  Chip Address |  Flag |  Len  |    Ack  |  Status |  Sum  |
*                      -----------------------------------------------------------------------
*
** Type        : 1 - Basic FP test
** Date        : 2016/03/16
** ModifyRecord:
***************************************************************************************************/ 
UINT8 SF125_Production_Test(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
		UINT8 cAck, nStatus;
		UINT8 testType;
		UINT32 gpioResult;

		cAck = PS_OK;

		testType = cpRecBuf[10];
		switch(testType)
		{
				case 92:
					nStatus = Sensor_Test();
				break;
#if 0
				case 91:
					gpioResult = GPIO_Test();
					nStatus = (gpioResult >> 24) & 0xff;
				break;
#endif
				default:
					nStatus = MPT_NO_ACTION;
				break;
		}
		if(nStatus != 00) 
		{
		cAck = PS_SF125_TEST_ERROR;
		}
		
		psOutApp->cDatStus=COMM_INS;
		psOutApp->pcDat=gsCommHandle.pImgBuf;
		psOutApp->dwDatLen=0;

		psOutApp->cACK=cAck;
		psOutApp->pata[0]=cAck;
		psOutApp->pata[1]=nStatus;
		psOutApp->cpataLen=2;
		psOutApp->cDoStatus=DO_WAIT;

		return RT_OK;
}
#endif

#ifdef IMD_NFC_M24SR_TAG_APPLIED
UINT8 SF125_NFCTag(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
		UINT8 cAck;
		UINT8 type;

		type = cpRecBuf[10];
		switch(type)
		{
				case 71:		//Enter UI Mode
					DisableNFC();
				break;
				case 72:
					EnableNFC();
				break;
				default:
				break;
		}
		cAck = PS_OK;


		psOutApp->cDatStus=COMM_INS;
		psOutApp->pcDat=gsCommHandle.pImgBuf;
		psOutApp->dwDatLen=0;

		psOutApp->cACK=cAck;
		psOutApp->pata[0]=cAck;
		psOutApp->pata[1]=0x00;
		psOutApp->cpataLen=2;
		psOutApp->cDoStatus=DO_WAIT;

		return RT_OK;
}
#endif

/***************************************************************************************************
** Subroutine  : CmdValidTempleteNum
** Function    : УЧģ  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/  
UINT8 CmdValidTempleteNum(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
	UINT16 nwMBCounter;
	UINT8 cAck;

/*ȡģ*/
	nwMBCounter=UserStatistics();
	cAck = PS_OK;
	
	psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->pata[1] = nwMBCounter/256;
	psOutApp->pata[2] = nwMBCounter%256;
	psOutApp->cpataLen=3;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK; 
}

/***************************************************************************************************
** Subroutine  : CmdUserCommand
** Function    : GPIO  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/  
UINT8 CmdUserCommand(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{

	UINT8 cAck,nStatus=0;

	cAck = PS_OK;
	

    psOutApp->cDatStus=COMM_INS;
    psOutApp->pcDat=gsCommHandle.pImgBuf;
    psOutApp->dwDatLen=0;
    
    psOutApp->cACK=cAck;  
	psOutApp->pata[0]=cAck;
	psOutApp->pata[0]=nStatus;
	psOutApp->cpataLen=2;
	psOutApp->cDoStatus=DO_WAIT;
    return RT_OK;   
}

/***************************************************************************************************
** Subroutine  : CmdUserDefined
** Function    : ûԶ  
** Input       : UINT8 *cpRecBuf -- Э 
**               PKG_OUT_APP *psOutApp -- ָϢ,
** Output      : RT_OK:ɹ,RT_FAIL:ʧ 
** Description :   
** Date        : 2013/12/18
** ModifyRecord:
***************************************************************************************************/  
UINT8 CmdUserDefined(UINT8 *cpRecBuf,PKG_OUT_APP *psOutApp)
{
    return RT_OK;   
}

