/***************************************************************************************
* File name    :	Trng.h
* Function     :	The header of Trng.c
* Author       : 	Hongjz
* Date         :	2015/09/29
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _TRNG_H_
#define _TRNG_H_

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define TRNG_RAND_RESEED 		(1UL<<31)	//W1-Initiate reseed
#define TRNG_NONCE_RESEED 		(1UL<<30)	//W1-Initiate nonce reseed;
#define TRNG_NONCE_RESEED_LD    (1UL<<29)	//Load TRNG_DATA[0-3] registers into portion of nonce selected by the NONCE_SEED_SELECT bit
#define TRNG_NONCE_RESEED_SELECT (1UL<<28)	//W1-select 127 bit upper portion of nonce to reseed
#define TRNG_GET_NEW	 		(1UL << 0)
#define TRNG_BUSY				(1UL <<0)

#define TRNG_RAND_RESEED_MODE	1
#define TRNG_NONCE_RESEED_MODE	2
#define TRNG_SIZE_BYTES 		16
#define TRNG_SIZE_WORDS 		4 

#define TRNG_RDY_IRQ   				(1L<<27)
#define TRNG_CLEAR_RDY_IRQ_STAT		RngRegs.STATUS.all=0x08000000
#define TRNG_READ_RDY_IRQ_STAT		RngRegs.STATUS.all
#define LOOP_WAIT					80000000
/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	TRNG_Success = 0,
	TRNG_PARA_Err,		//
	TRNG_OTHER_Err,
}TRNG_RT;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/**************************************************************************
* Functon
***************************************************************************/
/*********************************************************************************************************
ԭͣ	UINT32 Trng_Init(UINT32 nMode)
˵	ʼ
˵	UINT32 nMode [I] --- ̶0			
ֵ	ALG_OK/ALG_OVERTIME_ERR
ע
********************************************************************************************************/
extern	UINT32 Trng_Init(UINT32 nMode);
/*********************************************************************************************************
ԭͣ	UINT32 Trng_GenRandom(UINT8 * pRandBuf, UINT16 nSize)
˵	
˵	UINT32* pBuf [O] --- 
˵	UINT16 nSize [I] --- 
ֵ	ALG_OK/ALG_OVERTIME_ERR/ALG_PARAM_ERR
ע
********************************************************************************************************/  
extern	UINT32 Trng_GenRandom(UINT8 * pRandBuf, UINT16 nSize);
/*********************************************************************************************************
ԭͣ	UINT32 Trng_GenRandomBit32(UINT32 * pRandBuf, UINT16 nSize)
˵	
˵	UINT32* pBuf [O] --- 
˵	UINT16 nSize [I] --- ֳ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/  
extern	UINT32 Trng_GenRandomBit32(UINT32 * pRandBuf, UINT16 nSize);

/*********************************************************************************************************
ԭͣ	UINT32 Trng_GenRandomBit32_Safety(UINT32 * pRandBuf, UINT16 nSize)
˵	
˵	UINT32* pRandBuf [O] --- 
˵	UINT16 nSize [I] --- ֳ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/  
extern	UINT32 Trng_GenRandomBit32_Safety(UINT32 * pRandBuf, UINT16 nSize);

/*********************************************************************************************************
ԭͣ	UINT32 Trng_GenRandomCheck(UINT8 * pRandBuf, UINT16 nSize)
˵	Լ
˵	UINT32* pBuf [O] --- 
˵	UINT16 nSize [I] --- 
ֵ	ALG_OK/ALG_OVERTIME_ERR/ALG_PARAM_ERR
ע
********************************************************************************************************/
extern	UINT32 Trng_GenRandomCheck(UINT8 * pRandBuf, UINT16 nSize);

/*********************************************************************************************************
ԭͣ	void Prng_GenRandom(UINT16 *pRandBuf,UINT16 nSize)
˵	ȡα
˵	UINT16* pRandBuf [O] --- 
˵	UINT16 nSize [I] --- 
ֵ	
ע
********************************************************************************************************/
extern	void Prng_GenRandom(UINT16 *pRandBuf,UINT16 nSize);

/*********************************************************************************************************
ԭͣ	void TrngVersion(INT8 data[12])
˵	Trng㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void TrngVersion(INT8 data[12]);

#endif

