/***************************************************************************************
* File name    :	SM4.h
* Function     :	The header of SM4.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _SMS4_H_
#define _SMS4_H_

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define SMS4_ENCRYPT 1
#define SMS4_DECRYPT 2
#define SMS4_CBC 1
#define SMS4_ECB 2
#define SMS4_CFB 3
#define SMS4_OFB 4

/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	SM4_Success = 0,
	SM4_Err,
}SM4_RT;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/
/*********************************************************************************************************
ԭͣ	UINT8 SM4_Init(UINT8* pEK,UINT8* pAK)
˵	SM4 Կʼ
˵	UINT8* pEK [I] -- 16ֽ			
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SMS4_Init(UINT8* pEK);

/*********************************************************************************************************
ԭͣ	UINT8 _SMS4_Run(UINT8 nType,UINT32 nAddr,UINT16 nDataLen)
˵	SM4Ӳ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT32 nAddr [I] -- ׵ַҲ׵ַÿռΪ0x20020000~0x20020800
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
ֵ	0ɹֵʧ
ע	úֻECBģʽ㣬úֱӵ㷨ҪûݷŵnAddrַnAddrַȡ
********************************************************************************************************/
extern	UINT8 _SMS4_Run(UINT8 nType,UINT32 nAddr,UINT16 nDataLen);

/*********************************************************************************************************
ԭͣ	UINT8 SMS4_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen)
˵	SMS4 ECBģʽӽ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPaddingСڵ1024
ֵ	0ɹֵʧ
ע	
********************************************************************************************************/ 
extern	UINT8 SMS4_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen);

/*********************************************************************************************************
ԭͣ	UINT8 SMS4_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SMS4 CBCģʽӽ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SMS4_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);


/*********************************************************************************************************
ԭͣ	UINT8 SMS4_Run_CFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SMS4 CFBģʽӽ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SMS4_Run_CFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	UINT8 SMS4_Run_OFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SMS4 OFBģʽӽ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVصIVֵڸģʽ´㣬Ϊ16ֽ
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SMS4_Run_OFB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	UINT8 SMS4_Run(UINT8 nType,UINT8 nMode,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	SM4ӽ㡢֧CBCECBCFBOFBģʽ
˵	UINT8  nType [I] -- SMS4_ENCRYPT/SMS4_DECRYPT
			UINT8  nMode [I] -- SMS4_CBC/SMS4_ECB/SMS4_CFB/SMS4_OFB
			UINT8* pIn [I] --
			UINT8* pOut [O] --
			UINT16 nDataLen [I] -- ݳȣΪ16ıPadding
			UINT8* pIV [I/O] --  IVIVֵ´㣬Ϊ16ֽڡΪECBģʽʱֵӦΪNULL
ֵ	0ɹֵʧ
ע	ΪIV壬ͬʱҪշصIVҪԭʼIVʱҪԭʼIV
********************************************************************************************************/
extern	UINT8 SMS4_Run(UINT8 nType,UINT8 nMode,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/*********************************************************************************************************
ԭͣ	void Sm4Version(INT8 data[12])
˵	SM4㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void Sm4Version(INT8 data[12]);

#endif

