/***************************************************************************************
* File name    :	ECC.h
* Function     :	The header of ECC.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _SM2_H_
#define _SM2_H_

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define MAX_BYTE_LEN 32 //ECC ˽Կֽڸֵ֧ECC㷨ΪMAX_BYTE_LEN*8 
/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	SM2_Success = 0,
	SM2_PARA_Err,		//
	SM2_OTHER_Err,		//
}SM2_RT;

typedef struct _sm3Value
{
	UINT8*  Buf;
}SM3Value; 

typedef struct 
{		
	UINT8* PrivateKey;
}SM2_PriKey;

typedef struct 
{	
    UINT8* X;
	UINT8* Y;
}SM2_PubKey;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/*********************************************************************************************************
ԭͣ	UINT8 SM3_GetSignIDValue(SM3Value *pSm3v,SM2_PubKey* PubKey,UINT8 *pID,UINT32 IDLen)
˵	Zֵ 
˵	PubKey [I] --- SM2_PubKeyṹԿϢ
			sm3v [O] --- Ӵֵ
			pID [I] --- ûID
			IDLen [I] --- ûIDȡ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM3_GetSignIDValue(SM3Value *pSm3v,SM2_PubKey* PubKey,UINT8 *pID,UINT32 IDLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_GetHashValue(SM2_PubKey* PubKey,SM3Value* sm3v,UINT8 *pMsg,UINT32 msgLen,UINT8 *pID,UINT32 IDLen)
˵	Eֵ
˵	PubKey [I] --- SM2_PubKeyָԿϢָ롣
			sm3v [O] --- Ӵֵ
			pMsg [I] --- Ϣ
			msgLen [I] --- Ϣȡ
			pID [I] --- ûID
			IDLen [I] --- ûID
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM2_GetHashValue(SM2_PubKey* PubKey,SM3Value* sm3v,UINT8 *pMsg,UINT32 msgLen,UINT8 *pID,UINT32 IDLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_GenKey(SM2_PriKey *pPriKey,SM2_PubKey *pPubKey,UINT32 nBits,BOOL bPriKeyExist)
˵	SM2Կ
˵	pPriKey [I/O] ---  
					typedef struct 
					{
						UINT8*		PrivateKey;//˽ԿݣΪ32ֽ
					} SM2_PriKey;

			pPubKey [O] ---
					typedef struct 
					{				
						UINT8*		X;//ԿX,Ϊ32ֽ
						UINT8*		Y;//ԿY꣬Ϊ32ֽ
					} SM2_PubKey;
			nBits [I] ---	ΪnBitsλSM2ߣĿǰֻ֧256
			bPriKeyExist [I] --- BOOL1pPriKeyѾ˽Կݣ0˽ԿҪ
ֵ	0ɹֵʧ
ע	
********************************************************************************************************/
extern	UINT8 SM2_GenKey(SM2_PriKey *pPriKey,SM2_PubKey *pPubKey,UINT32 nBits,BOOL bPriKeyExist);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_Sign(SM2_PriKey* PriKey,UINT8 *pHash,UINT32 HashLen,UINT8 *pResult,UINT32 *pResultLen)
˵	õSM2ҪHashֵ
˵	PubKey [I] --- SM2_PubKeyָԿϢָ롣
			sm3v [O] --- Ӵֵ
			pMsg [I] --- Ϣ
			msgLen [I] --- Ϣȡ
			pID [I] --- ûID
			IDLen [I] --- ûID
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM2_Sign(SM2_PriKey* PriKey,UINT8 *pHash,UINT32 HashLen,UINT8 *pResult,UINT32 *pResultLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_Verify(SM2_PubKey* PubKey,UINT8 *pHash, UINT32 HashLen,UINT8 *pResult,UINT32 ResultLen)
˵	֤ͨԿǩ֤
˵	PubKey [I] --- SM2_PubKeyṹԿϢָ롣
			pHash [I] --- ӴԿ
			HashLen [I] --- ӴԿȡ
			pResult [I] --- ǩϢ
			ResultLen [I] --- ǩϢĳȡǩϢȡΪ2ԿȣԿΪ256򷵻صĳΪ2*256bit=64Bytes
ֵ	0ɹֵʧ
ע
********************************************************************************************************/ 
extern	UINT8 SM2_Verify(SM2_PubKey* PubKey,UINT8 *pHash, UINT32 HashLen,UINT8 *pResult,UINT32 ResultLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_KeyExc_Init(UINT32 *rA, Ep_Point *RA)
˵	ԿЭ̲,ûA
˵	rA [O] --- 
			RA [O] --- Բߵ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM2_KeyExc_Init(UINT32 *rA, Ep_Point *RA);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_KeyExc_Response(Ep_Point *RA, SM2_PriKey* sm2PriKeyB, SM2_PubKey* sm2PubKeyA,Ep_Point *RB, SM3Value *SB, SM3Value *S2,SM3Value* ZA,SM3Value* ZB,UINT8* pKey, UINT32 KLen)
˵	ӦЭԿЭ̲ûB
˵	RA [I] --- Э̲Բߵ
			sm2PriKeyB [I] --- Ӧ˽Կָ			
			sm2PubKeyA [I] --- 𷽹Կָ
			RB [O] --- Ӧ̲Բߵ
			SB [O] --- ӦЭ̲HASHֵ
			S2 [O] --- ӦЭ̲HASHֵ
			ZA [I] --- ûID 			
			ZB [I] --- ӦûID			
			pKey [O] --- ЭԿ
			KLen[I]-ҪЭ̵Կ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/ 
extern	UINT8 SM2_KeyExc_Response(Ep_Point *RA, SM2_PriKey* sm2PriKeyB, SM2_PubKey* sm2PubKeyA,Ep_Point *RB, SM3Value *SB, SM3Value *S2,SM3Value* ZA,SM3Value* ZB,UINT8* pKey, UINT32 KLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_KeyExc_Spons(UINT32 *rA, Ep_Point *RA,Ep_Point *RB, SM3Value *SB,SM2_PriKey* sm2PriKeyA, SM2_PubKey* sm2PubKeyB,SM3Value *SA,SM3Value* ZA,SM3Value* ZB,UINT8* pKey, UINT32 KLen)
˵	ЭԿ
˵	rA [I] --- Э̲ 
			RA [I] --- Э̲Բߵ
			RB [I] --- ӦЭ̲Բߵ
			SB [I] --- Ӧ̲ϣֵ 
			sm2PriKeyA [I] --- ˽Կָ			
			m2PubKeyB [I] --- ӦԿָ
			SA [O] --- Э̲ϣֵ
			ZA [I] --- ûID			
			ZB [I] --- ӦûID			
			pKey [O] --- ЭԿ
			KLen[I]-ҪЭ̵Կ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/ 
extern	UINT8 SM2_KeyExc_Spons(UINT32 *rA, Ep_Point *RA,Ep_Point *RB, SM3Value *SB,SM2_PriKey* sm2PriKeyA, SM2_PubKey* sm2PubKeyB,SM3Value *SA,SM3Value* ZA,SM3Value* ZB,UINT8* pKey, UINT32 KLen);
/*********************************************************************************************************
ԭͣ	UINT8 SM2_Key_Exchange(SM2_PriKey *sm2TmpPriA , SM2_PubKey *sm2TmpPubA , SM2_PubKey  *sm2TmpPubB ,SM2_PriKey *sm2PriKeyA , SM2_PubKey *sm2PubKeyB ,UINT8 ZA[32], UINT8 ZB[32],UINT8 KeyLen, UINT8 *pKey)
˵	ЭԿڷ𷽺ӦЭɹͬĻỰԿ
˵	sm2TmpPriA [I] ---ʱ˽Կ          
			sm2TmpPubA [I] --- ʱԿ
			sm2TmpPubB [I] ---ԷʱԿ                     
			sm2PriKeyA [I] ---˽Կ 
			sm2PubKeyB [I] ---ԷԿ 
			ZA [I] ---Zֵ
			ZB [I] ---ԷZֵ
			KeyLen [I] ---ҪЭ̳ĻỰԿ 
			pKey [O] ---ЭԿ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/ 
extern	UINT8 SM2_Key_Exchange(SM2_PriKey *sm2TmpPriA , SM2_PubKey *sm2TmpPubA , SM2_PubKey  *sm2TmpPubB ,SM2_PriKey *sm2PriKeyA , SM2_PubKey *sm2PubKeyB ,UINT8 ZA[32], UINT8 ZB[32],UINT8 KeyLen, UINT8 *pKey);
extern	UINT8 SM2_PubKeyEncrypt_Old(SM2_PubKey* PubKey, UINT8 *Buf, UINT32 *pBufLen, UINT8 *pM, UINT32 nMLen);
extern	UINT8 SM2_PriKeyDecrypt_Old(SM2_PriKey* PriKey,UINT8   *Buf,UINT32  *pBufLen, UINT8   *pEM, UINT32  nEMLen);
/*********************************************************************************************************
ԭͣ	UINT8 SM2_PubKeyEncrypt(SM2_PubKey* PubKey,UINT8 *Buf, UINT32 *pBufLen, UINT8 *pM, UINT32 nMLen)
˵	SM2Կ㡣Ӧ˳Ϲ2012׼
			˳0x04| C1| C3| C2
			˵	PubKey [I] --- SM2_PubKeyṹԿϢָ롣
			Buf [I] [O] --- 壬ΪNULL,pBufLenҪĻС
			pBufLen [I] [O] --- 뻺BufĴСʵʵļܺϢȡ븳ʼȣóֵʵʷسȡ
			pM [I] --- ûϢ
			nMLen [I] --- ûϢ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/   
extern	UINT8 SM2_PubKeyEncrypt(SM2_PubKey* PubKey,UINT8 *Buf, UINT32 *pBufLen, UINT8 *pM, UINT32 nMLen);

/*********************************************************************************************************
ԭͣ	UINT8 SM2_PriKeyDecrypt(SM2_PriKey* PriKey,UINT8   *Buf, UINT32  *pBufLen, UINT8   *pEM, UINT32  nEMLen)
		˵	SM2˽Կ㡣˳Ϲ2012׼˳0x04| C1| C3| C2	˵	PriKey [I] --- SM2_PriKeyṹ˽ԿϢָ롣
		Buf[I] [O] --- 壬ΪNULLpBufLenҪĻС
		pBufLen [I] [O] --- 뻺BufĴСʵʵĽܺϢȡ븳ʼȣóֵʵʷسȡ
		pEM [I] --- Ϣ
		nEMLen [I] --- Ϣ
ֵ	0ɹֵʧ
ע
********************************************************************************************************/
extern	UINT8 SM2_PriKeyDecrypt(SM2_PriKey* PriKey,UINT8   *Buf, UINT32  *pBufLen, UINT8   *pEM, UINT32  nEMLen);


/*********************************************************************************************************
ԭͣ	UINT8 SM2Check(void)
			˵	SM2У
			
ֵ	0ɹֵʧ
ע	ʹù̶˽Կе˲
********************************************************************************************************/
extern	UINT8 SM2Check(void);
/*********************************************************************************************************
ԭͣ	void Sm2Version(INT8 data[12])
˵	SM2㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void Sm2Version(INT8 data[12]);

#endif
