/***************************************************************************************
* File name    :	ECC.h
* Function     :	The header of ECC.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _ECC_H
#define _ECC_H

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/


/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	ECC_Success = 0,	
	ECC_OVERTIME_Err,	//ʱ
	ECC_POINT_Err,		//㲻
	ECC_PARA_Err,		//	
	ECC_VERIFY_Err,		//ǩ
}ECC_RT;

typedef struct 
{
	UINT32      nBits;		
    UINT8*		PrivateKey;
}ECC_PriKey;

typedef struct 
{
	UINT32      nBits;		
    UINT8*		X;
	UINT8*		Y;
}ECC_PubKey; 

/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/***************************************************************************
ԭͣ	UINT8 ECDSA_GenKey(ECC_PriKey *pPriKey, ECC_PubKey *pPubKey,
			UINT32 nBits, BOOL bPriKeyExist)
˵	Կ
ECDSAݽṹ£
			typedef struct 
			{
			UINT32      nBits;		//㷨λĿǰֻ֧256192		
			UINT8*		PrivateKey;	//˽ԿݣΪ32ֽ
			} ECC_PriKey;
			
			typedef struct 
			{
			UINT32      nBits;		
			UINT8*		X;//Կݣ32ֽ
			UINT8*		Y;//Կݣ32ֽ
			} ECC_PubKey;
˵	pPriKey [I] --- ECC_PriKeyṹ˽ԿϢ
			pPubKey [I][O] --- ECC_PubKeyṹԿ˽ԿpPriKeyͨECDSA㷨ɡ
			nBits [I] --- ΪnBitsλECDSAߣĿǰ֧192256
			bPriKeyExist [I] --- BOOL1pPriKeyѾ˽Կݣ0˽ԿҪɡ
ֵ	0ɹֵʧ
* *************************************************************************/
extern UINT8 ECDSA_GenKey(ECC_PriKey *pPriKey,ECC_PubKey *pPubKey,UINT32 nBits,BOOL bPriKeyExist);

/***************************************************************************
ԭͣ	UINT8 ECDSA_Sign(ECC_PriKey* PriKey,UINT8 *pHash,UINT32 HashLen,UINT8 *pResult,UINT32 *pResultLen)
˵	ǩ
˵	pPriKey [I] --- ECC_PriKeyṹ˽ԿϢָ롣
			pHash [I] --- Ӵֵ
			HashLen [I] --- ӴֵȣһΪ32ֽڻ20ֽڳ
			pResult [O] --- ǩϢ
			pResultLen [O] --- ǩϢȡΪ2ԿȣԿΪ192򷵻صĳΪ2*192bit=48Bytes
ֵ	0ɹֵʧ 
* *************************************************************************/
extern UINT8 ECDSA_Sign(ECC_PriKey* PriKey,UINT8 *pHash,UINT32 HashLen,UINT8 *pResult,UINT32 *pResultLen);

/***************************************************************************
ԭͣ	UINT8 ECDSA_Verify(ECC_PubKey* PubKey,UINT8 *pHash, UINT32 HashLen,UINT8 *pResult, UINT32 ResultLen)
˵	֤ͨԿǩ֤
˵	pPubKey [I] --- ECC_PubKeyṹԿϢָ롣
			pHash [I] --- Ӵֵ
			HashLen [I] --- Ӵֵȡ
			pResult [I] --- ǩϢ
			ResultLen [I] --- ǩϢ
ֵ	0ɹֵʧ
* *************************************************************************/
extern UINT8 ECDSA_Verify(ECC_PubKey* PubKey,UINT8 *pHash, UINT32 HashLen,UINT8 *pResult, UINT32 ResultLen);

/***************************************************************************
ԭͣ	UINT8 ECDSA_PubKeyEncrypt(ECC_PubKey* PubKey,UINT8 *Buf,UINT32 *pBufLen, UINT8 *pM, UINT32 nMLen)
˵	Կܣֻ֧һܣÿСΪECC㷨ȣnBits/8*2ֽ
˵	ECC_PubKey* PubKey [I] --- Կ
			UINT8 *Buf [O] --- ܽ
			UINT32 *pBufLen [I/O] --- ССΪECC㷨ȣnBits/8*4ֽڣECC 192Ϊ(192/8)*4=96ֽ
			UINT8 *pM [I] --- 
			UINT32 nMLen [I] --- ĳȣ̶Ϊ㷨ȣnBits/8*2ֽڣECC 192Ϊ(192/8)*2=48ֽڣԼ䡣
ֵ	0ɹֵʧ
* *************************************************************************/
extern UINT8 ECDSA_PubKeyEncrypt(ECC_PubKey* PubKey,UINT8 *Buf,UINT32 *pBufLen, UINT8 *pM, UINT32 nMLen);

/***************************************************************************
ԭͣ	UINT8 ECDSA_PriKeyDecrypt(ECC_PriKey* PriKey,UINT8   *Buf, UINT32  *pBufLen, UINT8   *pEM, UINT32  nEMLen)
˵	˽Կܣֻ֧һܣÿСΪECC㷨ȣnBits/8*4ֽ
˵	ECC_PriKey* PriKey [I] --- ˽Կ
			UINT8 *Buf [O] --- Ľ
			UINT32 *pBufLen [I/O] --- ССΪECC㷨ȣnBits/8*2ֽڣECC 192Ϊ(192/8)*2=48ֽ
			UINT8 *pM [I] --- 
			UINT32 nMLen [I] --- ĳȣ̶Ϊ㷨ȣnBits/8*4ֽڣECC 192Ϊ(192/8)*4=96ֽڣԼ䡣
ֵ	0ɹֵʧ
* *************************************************************************/
extern UINT8 ECDSA_PriKeyDecrypt(ECC_PriKey* PriKey,UINT8   *Buf, UINT32  *pBufLen, UINT8   *pEM, UINT32  nEMLen);

/***************************************************************************
ԭͣ	UINT8 ECDSA_KeyExchange(ECC_PubKey* PubKey,ECC_PriKey* PriKey,UINT8   *pKey, UINT32  *pKeyLen)
˵	Կ
˵	ECC_PubKey* PubKey [I] --- ԷĹԿ
			ECC_PriKey* PriKey [I] --- Լ˽Կ
			UINT8   *pKey [I/O] --- Կ
			UINT32  *pKeyLen [I] --- Կȣ̶Ϊ㷨ȣnBits/8*2ֽڣECC 192Ϊ(192/8)*2=48ֽ			
ֵ	0ɹֵʧ
* *************************************************************************/
extern UINT8 ECDSA_KeyExchange(ECC_PubKey* PubKey,ECC_PriKey* PriKey,UINT8   *pKey, UINT32  *pKeyLen);
/*********************************************************************************************************
ԭͣ	void EccVersion(INT8 data[12])
˵	ECC㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern void EccVersion(INT8 data[12]);


#endif
