/***************************************************************************************
* File name    :	DES.h
* Function     :	The header of DES.c
* Author       : 	Hongjz
* Date         :	2015/09/15
* Version      :    v1.0
* Description  :    
* ModifyRecord :
*****************************************************************************************/
#ifndef _DES_H_
#define _DES_H_

/***************************************************************************
* Include Header Files
***************************************************************************/


/**************************************************************************
* Global Macro Definition
***************************************************************************/
#define DES_ENCRYPT 1
#define DES_DECRYPT 2 

#define DES_CBC     1
#define DES_ECB     2
#define DES3_CBC    3
#define DES3_ECB    4
/**************************************************************************
* Global Type Definition
***************************************************************************/
typedef enum 
{
	DES_Success = 0, 
	DES_TYPE_Err,		//ʹ
	DES_MODE_Err,		//ģʽ
	DES_KEY_LEN_Err,	//Կȴ
	DES_Len_Err,		//볤ȴ8ֽڵΪ0ȴ1024
	DES_OVERTIME_Err,	//Ӳʱ
	DES_CMP_Err,		//ӽܲ
}DES_RT;
/**************************************************************************
* Global Variable Declaration
***************************************************************************/

/**************************************************************************
* Global Functon Declaration
***************************************************************************/

/***************************************************************************************
ԭͣ	UINT8 DES_Init(UINT8* pKey, UINT32 nKeyLen)
˵	ʼDESԿ
˵	pKey [I] --- Կ8ֽڣDES16ֽڣ2Key 3DES24ֽڣ3Key 3DES
						nKeyLen [I] --- ԿȣΪ8ֽڣΪDESʱ16ֽڣ2Key 3DESʱ24ֽڣΪ3Key 3DESʱ
ֵ	0ɹֵʧ	
ע
*****************************************************************************************/ 
extern	UINT8 DES_Init(UINT8* pKey,UINT32 nKeyLen);
/***************************************************************************************
ԭͣ	UINT8 DES_Run_ECB(UINT8 nType, UINT8* pIn, UINT8* pOut, UINT16 nDataLen)
˵	DES ECBģʽܻܡ
˵	nType [I] --- ܻܣ£
						#define 	DES_ENCRYPT 		1
						#define 	DES_DECRYPT 		2
						pIN [I] --- Ҫܻܵݡ
						pOut [O] --- 
						nDataLen [I] --- ݳȣΪ8ıPadding
ֵ	0ɹֵʧ
ע	
*****************************************************************************************/
extern	UINT8 DES_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen );

/***************************************************************************************
ԭͣ	UINT8 DES_Run_CBC(UINT8 nType, UINT8* pIn, UINT8* pOut,UINT16 nDataLen, UINT8* pIV)
˵	DES CBCģʽܻܡ
˵	nType [I] --- ܻܣ£
						#define 	DES_ENCRYPT 		1
						#define 	DES_DECRYPT 		2
						pIN [I] --- Ҫܻܵݡ
						pOut [O] --- 
						nDataLen [I] --- ݳȣΪ8ıPadding
						PIV [I][O] ---IVֵصIVֵCBCģʽ´㣬Ϊ8ֽڡ
ֵ	0ɹֵʧ
ע	ΪIVͬʱҪշصIVҪԭʼIVֵ
*****************************************************************************************/
extern	UINT8 DES_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/***************************************************************************************
ԭͣ	UINT8 DES3_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen )
˵	3DES ECBģʽܻܣԳʼΪ2Key3Key
˵	nType [I] --- ܻܣ£
						#define 	DES_ENCRYPT 		1
						#define 	DES_DECRYPT 		2
						pIN [I] --- Ҫܻܵݡ
						pOut [O] --- 
						nDataLen [I] --- ݳȣΪ8ıPadding
ֵ	0ɹֵʧ
ע	
*****************************************************************************************/
extern	UINT8 DES3_Run_ECB(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen );

/***************************************************************************************
ԭͣ	UINT8 DES3_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV)
˵	3DES CBCģʽܻܣԳʼΪ2Key3Key
˵	nType [I] --- ܻܣ£
						#define 	DES_ENCRYPT 		1
						#define 	DES_DECRYPT 		2
						pIN [I] --- Ҫܻܵݡ
						pOut [O] --- 
						nDataLen [I] --- ݳȣΪ8ıPadding
						PIV [I][O] --- IVֵصIVֵCBCģʽ´㣬Ϊ8ֽڡ
ֵ	0ɹֵʧ
ע	ΪIVͬʱҪշصIVҪԭʼIVֵ
*****************************************************************************************/
extern	UINT8 DES3_Run_CBC(UINT8 nType,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);
/***************************************************************************************
ԭͣ	UINT8 DES_Run(UINT8 nType, UINT8 nMode, UINT8* pIn, UINT8* pOut, UINT16 nDataLen, UINT8* pIV)
˵	DESܻܡ
˵	nType [I] --- ܻܣ£
						#define 	DES_ENCRYPT 		1
						#define 	DES_DECRYPT 		2
						nMode [I] --- ECBCBC£
						#define		DES_CBC		1
						#define 	DES_ECB		2
						#define		DES3_CBC	3
						#define 	DES3_ECB	4
						pIN [I] --- Ҫܻܵݡ
						pOut [O] --- 
						nDataLen [I] --- ݳȣΪ8ıPadding
						PIV [IO] --- IVֵصIVֵCBCģʽ´㣬Ϊ8ֽڡ

ֵ	0ɹֵʧ
ע	ΪIVͬʱҪշصIVֵҪԭʼIVֵС
*****************************************************************************************/
extern	UINT8 DES_Run(UINT8 nType,UINT8 nMode,UINT8* pIn,UINT8* pOut,UINT16 nDataLen,UINT8* pIV);

/***************************************************************************************
ԭͣ	UINT8 _Des_Run(UINT8 nType,UINT8 nMode,UINT32 nAddr,UINT16 nDataLen)
˵	DES3DESECBģʽܻܡ
˵	nType [I] --- DES_ENCRYPT/DES_DECRYPT
			nMode [I] --- DES_ECB/DES3_ECB						
			UINT32 nAddr [I] -- ׵ַҲ׵ַÿռΪ0x20020000~0x20020800
			UINT16 nDataLen [I] -- ݳȣΪ8ıPadding
ֵ	0ɹֵʧ
ע	úֱӵ㷨ҪûݷŵnAddrַnAddrַȡ
*****************************************************************************************/
extern	UINT8 _Des_Run(UINT8 nType,UINT8 nMode,UINT32 nAddr,UINT16 nDataLen);

/*********************************************************************************************************
ԭͣ	void DesVersion(INT8 data[12])
˵	DES㷨汾Żȡ
˵	INT8 data [O] -- 㷨汾			
ֵ	
ע	
********************************************************************************************************/ 
extern	void DesVersion(INT8 data[12]);
 
#endif
